/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled;

import com.codahale.metrics.MetricRegistry;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.geometry.GeneralEnvelope;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.map.style.json.ColorParser;
import org.mapfish.print.map.tiled.CoverageTask;
import org.mapfish.print.map.tiled.TileCacheInformation;
import org.mapfish.print.map.tiled.TilePreparationInfo;
import org.opengis.geometry.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CoverageTask
implements Callable<GridCoverage2D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoverageTask.class);
    private final TileCacheInformation tiledLayer;
    private final TilePreparationInfo tilePreparationInfo;
    private final boolean failOnError;
    private final MetricRegistry registry;
    private final String jobId;
    private final BufferedImage errorImage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoverageTask(@Nonnull TilePreparationInfo tilePreparationInfo, boolean failOnError, @Nonnull MetricRegistry registry, @Nonnull String jobId, @Nonnull TileCacheInformation tileCacheInfo, @Nonnull Configuration configuration) {
        this.tilePreparationInfo = tilePreparationInfo;
        this.jobId = jobId;
        this.tiledLayer = tileCacheInfo;
        this.failOnError = failOnError;
        this.registry = registry;
        Dimension tileSize = this.tiledLayer.getTileSize();
        this.errorImage = new BufferedImage(tileSize.width, tileSize.height, 6);
        Graphics2D graphics = this.errorImage.createGraphics();
        try {
            graphics.setBackground(ColorParser.toColor((String)configuration.getOpaqueTileErrorColor()));
            graphics.clearRect(0, 0, tileSize.width, tileSize.height);
        }
        finally {
            graphics.dispose();
        }
    }

    @Override
    public GridCoverage2D call() {
        try {
            BufferedImage coverageImage = this.tiledLayer.createBufferedImage(this.tilePreparationInfo.getImageWidth(), this.tilePreparationInfo.getImageHeight());
            Graphics2D graphics = coverageImage.createGraphics();
            for (TilePreparationInfo.SingleTilePreparationInfo tileInfo : this.tilePreparationInfo.getSingleTiles()) {
                Object task = tileInfo.getTileRequest() != null ? new SingleTileLoaderTask(tileInfo.getTileRequest(), this.errorImage, tileInfo.getTileIndexX(), tileInfo.getTileIndexY(), this.failOnError, this.registry, this.jobId) : new PlaceHolderImageTask(this.tiledLayer.getMissingTileImage(), tileInfo.getTileIndexX(), tileInfo.getTileIndexY());
                Tile tile = task.call();
                if (tile.getImage() == null) continue;
                graphics.drawImage((Image)tile.getImage(), tile.getxIndex() * this.tiledLayer.getTileSize().width, tile.getyIndex() * this.tiledLayer.getTileSize().height, null);
            }
            graphics.dispose();
            GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
            GeneralEnvelope gridEnvelope = new GeneralEnvelope(this.tilePreparationInfo.getMapProjection());
            gridEnvelope.setEnvelope(new double[]{this.tilePreparationInfo.getGridCoverageOrigin().x, this.tilePreparationInfo.getGridCoverageOrigin().y, this.tilePreparationInfo.getGridCoverageMaxX(), this.tilePreparationInfo.getGridCoverageMaxY()});
            return factory.create((CharSequence)this.tiledLayer.createCommonUrl(), (RenderedImage)coverageImage, (Envelope)gridEnvelope, null, null, null);
        }
        catch (Exception e) {
            throw ExceptionUtils.getRuntimeException((Throwable)e);
        }
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

