/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled.wmts;

import com.codahale.metrics.MetricRegistry;
import java.awt.Rectangle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.geotools.coverage.grid.GridCoverage2D;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.map.AbstractLayerParams;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.tiled.AbstractTiledLayer;
import org.mapfish.print.map.tiled.TileCacheInformation;
import org.mapfish.print.map.tiled.wmts.WMTSLayer;
import org.mapfish.print.map.tiled.wmts.WMTSLayerParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMTSLayer
extends AbstractTiledLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WMTSLayer.class);
    private final WMTSLayerParam param;

    protected WMTSLayer(@Nullable ForkJoinPool forkJoinPool, @Nullable StyleSupplier<GridCoverage2D> styleSupplier, @Nonnull WMTSLayerParam param, @Nullable MetricRegistry registry, @Nonnull Configuration configuration) {
        super(forkJoinPool, styleSupplier, (AbstractLayerParams)param, registry, configuration);
        this.param = param;
    }

    protected final TileCacheInformation createTileInformation(MapBounds bounds, Rectangle paintArea, double dpi) {
        return new WMTSTileCacheInfo(this, bounds, paintArea, dpi);
    }

    public static URI createRestURI(String matrixId, int row, int col, WMTSLayerParam layerParam) throws URISyntaxException {
        String path = layerParam.baseURL;
        if (layerParam.dimensions != null) {
            for (int i = 0; i < layerParam.dimensions.length; ++i) {
                String dimension = layerParam.dimensions[i];
                String value = layerParam.dimensionParams.optString(dimension);
                if (value == null) {
                    value = layerParam.dimensionParams.getString(dimension.toUpperCase());
                }
                path = path.replace("{" + dimension + "}", value);
            }
        }
        path = path.replace("{TileMatrixSet}", layerParam.matrixSet);
        path = path.replace("{TileMatrix}", matrixId);
        path = path.replace("{TileRow}", String.valueOf(row));
        path = path.replace("{TileCol}", String.valueOf(col));
        path = path.replace("{style}", layerParam.style);
        path = path.replace("{Layer}", layerParam.layer);
        return new URI(path);
    }

    public final MapLayer.RenderType getRenderType() {
        return MapLayer.RenderType.fromMimeType((String)this.param.imageFormat);
    }

    static /* synthetic */ WMTSLayerParam access$000(WMTSLayer x0) {
        return x0.param;
    }

    static /* synthetic */ double access$102(WMTSLayer x0, double x1) {
        x0.imageBufferScaling = x1;
        return x0.imageBufferScaling;
    }
}

