/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.parser;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.ExtraPropertyException;
import org.mapfish.print.MissingPropertyException;
import org.mapfish.print.attribute.PrimitiveAttribute;
import org.mapfish.print.parser.CanSatisfyOneOf;
import org.mapfish.print.parser.HasDefaultValue;
import org.mapfish.print.parser.MapfishParser;
import org.mapfish.print.parser.OneOf;
import org.mapfish.print.parser.OneOfTracker;
import org.mapfish.print.parser.ParserUtils;
import org.mapfish.print.parser.RequiresTracker;
import org.mapfish.print.wrapper.ObjectMissingException;
import org.mapfish.print.wrapper.PArray;
import org.mapfish.print.wrapper.PObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class MapfishParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapfishParser.class);
    private static final String POST_CONSTRUCT_METHOD_NAME = "postConstruct";

    private MapfishParser() {
    }

    public static void parse(boolean errorOnExtraProperties, PObject requestData, Object objectToPopulate, String ... extraPropertyToIgnore) {
        MapfishParser.checkForExtraProperties((boolean)errorOnExtraProperties, objectToPopulate.getClass(), (PObject)requestData, (String[])extraPropertyToIgnore);
        Collection allAttributes = ParserUtils.getAttributes(objectToPopulate.getClass(), (com.google.common.base.Predicate)ParserUtils.FILTER_NON_FINAL_FIELDS);
        HashMap missingProperties = Maps.newHashMap();
        OneOfTracker oneOfTracker = new OneOfTracker();
        RequiresTracker requiresTracker = new RequiresTracker();
        for (Field attribute : allAttributes) {
            oneOfTracker.register(attribute);
            requiresTracker.register(attribute);
        }
        for (Field property : allAttributes) {
            try {
                Object value;
                try {
                    value = MapfishParser.parseValue((boolean)errorOnExtraProperties, (String[])extraPropertyToIgnore, property.getType(), (String)property.getName(), (PObject)requestData);
                }
                catch (UnsupportedTypeException e) {
                    String paramClassName = objectToPopulate.getClass().getName();
                    String type = UnsupportedTypeException.access$000((UnsupportedTypeException)e).getName();
                    if (UnsupportedTypeException.access$000((UnsupportedTypeException)e).isArray()) {
                        type = UnsupportedTypeException.access$000((UnsupportedTypeException)e).getComponentType().getName() + "[]";
                    }
                    throw new RuntimeException("The type '" + type + "' is not a supported type when parsing json.  See documentation for supported types.\n\nUnsupported type found in " + paramClassName + " under the property: " + property.getName() + "\n\nTo support more types add the type to parseValue and parseArrayValue in this class and add a test to the test class", e);
                }
                try {
                    oneOfTracker.markAsVisited(property);
                    requiresTracker.markAsVisited(property);
                    property.set(objectToPopulate, value);
                }
                catch (IllegalAccessException e) {
                    throw ExceptionUtils.getRuntimeException((Throwable)e);
                }
            }
            catch (ObjectMissingException e) {
                HasDefaultValue hasDefaultValue = property.getAnnotation(HasDefaultValue.class);
                OneOf oneOf = property.getAnnotation(OneOf.class);
                CanSatisfyOneOf canSatisfyOneOf = property.getAnnotation(CanSatisfyOneOf.class);
                if (hasDefaultValue != null || oneOf != null || canSatisfyOneOf != null) continue;
                missingProperties.put(property.getName(), property.getType());
            }
        }
        oneOfTracker.checkAllGroupsSatisfied(requestData.getCurrentPath());
        requiresTracker.checkAllRequirementsSatisfied(requestData.getCurrentPath());
        if (!missingProperties.isEmpty()) {
            String message = "Request Json is missing some required attributes at: '" + requestData.getCurrentPath() + "': ";
            throw new MissingPropertyException(message, (Map)missingProperties, ParserUtils.getAllAttributeNames(objectToPopulate.getClass()));
        }
        try {
            Method method = objectToPopulate.getClass().getMethod("postConstruct", new Class[0]);
            LOGGER.debug("Executing postConstruct method on parameter object.");
            method.invoke(objectToPopulate, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LOGGER.debug("No postConstruct method on parameter object.");
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void checkForExtraProperties(boolean errorOnExtraProperties, Class<?> paramClass, PObject layer, String[] extraPropertyToIgnore) {
        HashSet acceptableKeyValues = Sets.newHashSet();
        for (String name : ParserUtils.getAttributeNames(paramClass, (Predicate)ParserUtils.FILTER_NON_FINAL_FIELDS)) {
            acceptableKeyValues.add(name.toLowerCase());
        }
        if (extraPropertyToIgnore != null) {
            for (String propName : extraPropertyToIgnore) {
                acceptableKeyValues.add(propName.toLowerCase());
            }
        }
        HashSet extraProperties = Sets.newHashSet();
        Iterator keys = layer.keys();
        while (keys.hasNext()) {
            String next = (String)keys.next();
            if (acceptableKeyValues.contains(next.toLowerCase())) continue;
            extraProperties.add(next);
        }
        if (!extraProperties.isEmpty()) {
            String msg = "Extra properties were found in the request data at: " + layer.getCurrentPath() + ": ";
            ExtraPropertyException exception = new ExtraPropertyException(msg, (Collection)extraProperties, ParserUtils.getAttributeNames(paramClass, field -> true));
            if (errorOnExtraProperties) {
                throw exception;
            }
            LOGGER.warn(exception.getMessage(), (Throwable)exception);
        }
    }

    private static Object parseValue(boolean errorOnExtraProperties, String[] extraPropertyToIgnore, Class<?> type, String fieldName, PObject layer) throws UnsupportedTypeException {
        Object value;
        String name = fieldName;
        if (!layer.has(name) && layer.has(name.toLowerCase())) {
            name = name.toLowerCase();
        }
        if (type == String.class) {
            value = layer.getString(name);
        } else if (type == Integer.class || type == Integer.TYPE) {
            value = layer.getInt(name);
        } else if (type == Long.class || type == Long.TYPE) {
            value = layer.getLong(name);
        } else if (type == Double.class || type == Double.TYPE) {
            value = layer.getDouble(name);
        } else if (type == Float.class || type == Float.TYPE) {
            value = Float.valueOf(layer.getFloat(name));
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            value = layer.getBool(name);
        } else if (PObject.class.isAssignableFrom(type)) {
            value = layer.getObject(name);
        } else if (PArray.class.isAssignableFrom(type)) {
            value = layer.getArray(name);
        } else if (type == URL.class) {
            try {
                value = new URL(layer.getString(name));
            }
            catch (MalformedURLException e) {
                throw ExceptionUtils.getRuntimeException((Throwable)e);
            }
        } else if (type.isArray()) {
            PArray array = layer.getArray(name);
            value = Array.newInstance(type.getComponentType(), array.size());
            for (int i = 0; i < array.size(); ++i) {
                Object arrayValue = MapfishParser.parseArrayValue((boolean)errorOnExtraProperties, (String[])extraPropertyToIgnore, type.getComponentType(), (int)i, (PArray)array);
                if (arrayValue == null) {
                    throw new IllegalArgumentException("Arrays cannot have null values in them.  Error found with: " + array + " when being converted to a " + type.getComponentType());
                }
                Array.set(value, i, arrayValue);
            }
        } else if (type.isEnum()) {
            value = MapfishParser.parseEnum(type, (String)layer.getPath(fieldName), (String)layer.getString(name));
        } else {
            try {
                value = type.newInstance();
                PObject object = layer.getObject(name);
                MapfishParser.parse((boolean)errorOnExtraProperties, (PObject)object, (Object)value, (String[])extraPropertyToIgnore);
            }
            catch (InstantiationException e) {
                throw new UnsupportedTypeException(type, (Exception)e, null);
            }
            catch (IllegalAccessException e) {
                throw ExceptionUtils.getRuntimeException((Throwable)e);
            }
        }
        return value;
    }

    private static Object parseEnum(Class<?> type, String path, String enumString) {
        try {
            int ordinal = Integer.parseInt(enumString);
            Object[] enumConstants = type.getEnumConstants();
            if (ordinal < enumConstants.length) {
                return enumConstants[ordinal];
            }
            throw MapfishParser.enumError((Object[])enumConstants, (String)path, (String)enumString);
        }
        catch (NumberFormatException ne) {
            ?[] enumConstants;
            for (Object enumConstant : enumConstants = type.getEnumConstants()) {
                if (!enumConstant.toString().equalsIgnoreCase(enumString) && !((Enum)enumConstant).name().equalsIgnoreCase(enumString)) continue;
                return enumConstant;
            }
            throw MapfishParser.enumError((Object[])type.getEnumConstants(), (String)path, (String)enumString);
        }
    }

    private static IllegalArgumentException enumError(Object[] enumConstants, String path, String enumString) {
        return new IllegalArgumentException(path + " should be an enumeration value or ordinal but was: " + enumString + "\nEnum constants are: " + Arrays.toString(enumConstants));
    }

    private static Object parseArrayValue(boolean errorOnExtraProperties, String[] extraPropertyToIgnore, Class<?> type, int i, PArray array) throws UnsupportedTypeException {
        Object value;
        if (type == String.class) {
            value = array.getString(i);
        } else if (type == Integer.class || type == Integer.TYPE) {
            value = array.getInt(i);
        } else if (type == Long.class || type == Long.TYPE) {
            value = array.getLong(i);
        } else if (type == Double.class || type == Double.TYPE) {
            value = array.getDouble(i);
        } else if (type == Float.class || type == Float.TYPE) {
            value = Float.valueOf(array.getFloat(i));
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            value = array.getBool(i);
        } else if (PObject.class.isAssignableFrom(type)) {
            value = array.getObject(i);
        } else if (PArray.class.isAssignableFrom(type)) {
            value = array.getArray(i);
        } else {
            if (type == URL.class) {
                try {
                    value = new URL(array.getString(i));
                }
                catch (MalformedURLException e) {
                    throw ExceptionUtils.getRuntimeException((Throwable)e);
                }
            }
            if (type.isEnum()) {
                value = MapfishParser.parseEnum(type, (String)array.getPath("" + i), (String)array.getString(i));
            } else {
                try {
                    value = type.newInstance();
                    PObject object = array.getObject(i);
                    MapfishParser.parse((boolean)errorOnExtraProperties, (PObject)object, (Object)value, (String[])extraPropertyToIgnore);
                }
                catch (InstantiationException e) {
                    throw new UnsupportedTypeException(type, (Exception)e, null);
                }
                catch (IllegalAccessException e) {
                    throw ExceptionUtils.getRuntimeException((Throwable)e);
                }
            }
        }
        return value;
    }

    public static Object parsePrimitive(String fieldName, PrimitiveAttribute<?> pAtt, PObject requestData) {
        Object value;
        Class valueClass = pAtt.getValueClass();
        try {
            value = MapfishParser.parseValue((boolean)false, (String[])new String[0], (Class)valueClass, (String)fieldName, (PObject)requestData);
        }
        catch (UnsupportedTypeException e) {
            String type = UnsupportedTypeException.access$000((UnsupportedTypeException)e).getName();
            if (UnsupportedTypeException.access$000((UnsupportedTypeException)e).isArray()) {
                type = UnsupportedTypeException.access$000((UnsupportedTypeException)e).getComponentType().getName() + "[]";
            }
            throw new RuntimeException("The type '" + type + "' is not a supported type when parsing json.  See documentation for supported types.\n\nUnsupported type found in attribute " + fieldName + "\n\nTo support more types add the type to parseValue and parseArrayValue in this class and add a test to the test class", e);
        }
        pAtt.validateValue(value);
        return value;
    }

    public static String stringRepresentation(Class<?> aClass) {
        return aClass.getSimpleName();
    }
}

