/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.parser;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.vividsolutions.jts.util.Assert;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.mapfish.print.parser.CanSatisfyOneOf;
import org.mapfish.print.parser.OneOf;
import org.mapfish.print.parser.OneOfTracker;

/*
 * Exception performing whole class analysis ignored.
 */
final class OneOfTracker {
    private Map<String, OneOfGroup> mapping = Maps.newHashMap();

    OneOfTracker() {
    }

    public void register(Field field) {
        OneOf oneOfAnnotation = field.getAnnotation(OneOf.class);
        String groupName = null;
        if (oneOfAnnotation != null) {
            groupName = oneOfAnnotation.value();
        } else {
            CanSatisfyOneOf canSatisfyOneOf = field.getAnnotation(CanSatisfyOneOf.class);
            if (canSatisfyOneOf != null) {
                groupName = canSatisfyOneOf.value();
            }
        }
        if (groupName != null) {
            OneOfGroup oneOfGroup = (OneOfGroup)this.mapping.get(groupName);
            if (oneOfGroup == null) {
                oneOfGroup = new OneOfGroup(groupName);
                this.mapping.put(groupName, oneOfGroup);
            }
            OneOfGroup.access$000((OneOfGroup)oneOfGroup).add(field);
        }
    }

    public void markAsVisited(Field field) {
        CanSatisfyOneOf canSatisfyOneOf;
        OneOf oneOfAnnotation = field.getAnnotation(OneOf.class);
        if (oneOfAnnotation != null) {
            OneOfGroup oneOfGroup = (OneOfGroup)this.mapping.get(oneOfAnnotation.value());
            OneOfGroup.access$100((OneOfGroup)oneOfGroup).add(new OneOfSatisfier(field, false));
        }
        if ((canSatisfyOneOf = field.getAnnotation(CanSatisfyOneOf.class)) != null) {
            OneOfGroup oneOfGroup = (OneOfGroup)this.mapping.get(canSatisfyOneOf.value());
            OneOfGroup.access$100((OneOfGroup)oneOfGroup).add(new OneOfSatisfier(field, true));
        }
    }

    public void checkAllGroupsSatisfied(String currentPath) {
        StringBuilder errors = new StringBuilder();
        for (OneOfGroup group : this.mapping.values()) {
            Collection oneOfSatisfiers;
            if (OneOfGroup.access$100((OneOfGroup)group).isEmpty()) {
                errors.append("\n");
                errors.append("\t* The OneOf choice: ").append(OneOfGroup.access$200((OneOfGroup)group)).append(" was not satisfied.  One (and only one) of the ");
                errors.append("following fields is required in the request data: ").append(this.toNames(OneOfGroup.access$000((OneOfGroup)group)));
            }
            if ((oneOfSatisfiers = Collections2.filter((Collection)OneOfGroup.access$100((OneOfGroup)group), (Predicate)new /* Unavailable Anonymous Inner Class!! */)).size() <= 1) continue;
            errors.append("\n");
            errors.append("\t* The OneOf choice: ").append(OneOfGroup.access$200((OneOfGroup)group)).append(" was satisfied by too many fields.  Only one choice ");
            errors.append("may be in the request data.  The fields found were: ").append(this.toNames(this.toFields(OneOfGroup.access$100((OneOfGroup)group))));
        }
        Assert.equals((Object)0, (Object)errors.length(), (String)("\nErrors were detected when analysing the @OneOf dependencies of '" + currentPath + "': \n" + errors));
    }

    private Collection<Field> toFields(Set<OneOfSatisfier> satisfiedBy) {
        return Collections2.transform(satisfiedBy, (Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String toNames(Collection<Field> choices) {
        StringBuilder names = new StringBuilder();
        for (Field choice : choices) {
            if (names.length() > 0) {
                names.append(", ");
            }
            String type = choice.getType().getName();
            if (choice.getType().isArray()) {
                type = choice.getType().getComponentType().getName() + "[]";
            }
            names.append(type).append(' ').append(choice.getName());
        }
        return names.toString();
    }
}

