/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.annotation.Nonnull;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.parser.ParserUtils;
import org.mapfish.print.processor.Processor;

public abstract class AbstractProcessor<In, Out>
implements Processor<In, Out> {
    private final BiMap<String, String> inputMapper = HashBiMap.create();
    private final BiMap<String, String> outputMapper = HashBiMap.create();
    private final Class<Out> outputType;
    private String prefix;
    private String inputPrefix;
    private String outputPrefix;

    protected AbstractProcessor(Class<Out> outputType) {
        this.outputType = outputType;
    }

    public final Class<Out> getOutputType() {
        return this.outputType;
    }

    @Nonnull
    public final BiMap<String, String> getInputMapperBiMap() {
        return this.inputMapper;
    }

    public final void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public final void setInputPrefix(String inputPrefix) {
        this.inputPrefix = inputPrefix;
    }

    public final String getInputPrefix() {
        return this.inputPrefix == null ? this.prefix : this.inputPrefix;
    }

    public final void setOutputPrefix(String outputPrefix) {
        this.outputPrefix = outputPrefix;
    }

    public final String getOutputPrefix() {
        return this.outputPrefix == null ? this.prefix : this.outputPrefix;
    }

    public void toString(StringBuilder builder, int indent, String parent) {
        int spaces = indent * 2;
        for (int i = 0; i < spaces; ++i) {
            builder.append(' ');
        }
        builder.append("\"");
        builder.append(parent.replace("\"", "\\\""));
        builder.append("\" -> \"");
        builder.append(this.toString().replace("\"", "\\\""));
        builder.append("\";\n");
    }

    public final void setInputMapper(@Nonnull Map<String, String> inputMapper) {
        this.inputMapper.putAll(inputMapper);
    }

    @Nonnull
    public final BiMap<String, String> getOutputMapperBiMap() {
        return this.outputMapper;
    }

    public final void setOutputMapper(@Nonnull Map<String, String> outputMapper) {
        this.outputMapper.putAll(outputMapper);
    }

    public final void validate(List<Throwable> errors, Configuration configuration) {
        Object inputParameter = this.createInputParameter();
        Set allInputAttributeNames = inputParameter != null ? ParserUtils.getAllAttributeNames(inputParameter.getClass()) : Collections.emptySet();
        for (String inputAttributeName : this.inputMapper.values()) {
            if (allInputAttributeNames.contains(inputAttributeName)) continue;
            errors.add((Throwable)new ConfigurationException(inputAttributeName + " is not defined in processor '" + this + "'.  Check for typos. Options are " + allInputAttributeNames));
        }
        Set allOutputAttributeNames = ParserUtils.getAllAttributeNames((Class)this.getOutputType());
        for (String outputAttributeName : this.outputMapper.keySet()) {
            if (allOutputAttributeNames.contains(outputAttributeName)) continue;
            errors.add((Throwable)new ConfigurationException(outputAttributeName + " is not defined in processor '" + this + "' as an output attribute.  Check for typos. Options are " + allOutputAttributeNames));
        }
        this.extraValidation(errors, configuration);
    }

    protected abstract void extraValidation(List<Throwable> var1, Configuration var2);

    protected final void checkCancelState(Processor.ExecutionContext context) {
        if (context.isCanceled()) {
            throw new CancellationException("task was canceled");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this);
    }
}

