/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.jasper;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.design.JRValidationException;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.HasConfiguration;
import org.mapfish.print.config.WorkingDirectories;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.jasper.JasperReportBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public final class JasperReportBuilder
extends AbstractProcessor<Input, Void>
implements HasConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(JasperReportBuilder.class);
    public static final String JASPER_REPORT_XML_FILE_EXT = ".jrxml";
    public static final String JASPER_REPORT_COMPILED_FILE_EXT = ".jasper";
    private File directory = null;
    private Configuration configuration;
    @Autowired
    private MetricRegistry metricRegistry;
    @Autowired
    private WorkingDirectories workingDirectories;

    protected JasperReportBuilder() {
        super(Void.class);
    }

    public Void execute(Input param, Processor.ExecutionContext context) throws JRException {
        for (File jasperFile : this.jasperXmlFiles()) {
            this.checkCancelState(context);
            this.compileJasperReport(this.configuration, jasperFile);
        }
        return null;
    }

    File compileJasperReport(Configuration config, File jasperFile) throws JRException {
        File buildFile = this.workingDirectories.getBuildFileFor(config, jasperFile, JASPER_REPORT_COMPILED_FILE_EXT, LOGGER);
        return this.compileJasperReport(buildFile, jasperFile);
    }

    File compileJasperReport(File buildFile, File jasperFile) throws JRException {
        if (!buildFile.exists() || jasperFile.lastModified() > buildFile.lastModified()) {
            try {
                File tmpBuildFile = File.createTempFile("temp_", JASPER_REPORT_COMPILED_FILE_EXT, buildFile.getParentFile());
                LOGGER.info("Building Jasper report: {}", (Object)jasperFile.getAbsolutePath());
                LOGGER.debug("To: {}", (Object)buildFile.getAbsolutePath());
                Timer.Context compileJasperReport = this.metricRegistry.timer(this.getClass().getName() + ".compile." + jasperFile).time();
                try {
                    JasperCompileManager.compileReportToFile((String)jasperFile.getAbsolutePath(), (String)tmpBuildFile.getAbsolutePath());
                }
                catch (JRValidationException e) {
                    LOGGER.error("The report '{}' isn't valid.", (Object)jasperFile.getAbsolutePath());
                    throw e;
                }
                finally {
                    long compileTime = TimeUnit.MILLISECONDS.convert(compileJasperReport.stop(), TimeUnit.NANOSECONDS);
                    LOGGER.info("Report built in {}ms.", (Object)compileTime);
                }
                Files.move(tmpBuildFile.toPath(), buildFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                throw new JRException((Throwable)e);
            }
        }
        LOGGER.debug("Destination file is already up to date: " + buildFile.getAbsolutePath());
        return buildFile;
    }

    private Iterable<File> jasperXmlFiles() {
        File directoryToSearch = this.directory;
        if (directoryToSearch == null) {
            directoryToSearch = this.configuration.getDirectory();
        }
        String configurationAbsolutePath = this.configuration.getDirectory().getAbsolutePath();
        if (!directoryToSearch.getAbsolutePath().startsWith(configurationAbsolutePath)) {
            throw new IllegalArgumentException(String.format("All directories and files referenced in the configuration must be in the configuration directory: %s is not in %s.", directoryToSearch, this.configuration.getDirectory()));
        }
        Iterable children = com.google.common.io.Files.fileTreeTraverser().children((Object)directoryToSearch);
        return Iterables.filter((Iterable)children, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Input createInputParameter() {
        return new Input();
    }

    public void setDirectory(String directory) {
        this.directory = new File(this.configuration.getDirectory(), directory);
        if (!this.directory.exists()) {
            throw new IllegalArgumentException(String.format("Directory does not exist: %s.\nConfiguration contained value %s which is supposed to be relative to configuration directory.", this.directory, directory));
        }
        if (!this.directory.getAbsolutePath().startsWith(this.configuration.getDirectory().getAbsolutePath())) {
            throw new IllegalArgumentException(String.format("All files and directories must be contained in the configuration directory the directory provided in the configuration breaks that contract: %s in config file resolved to %s.", directory, this.directory));
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.directory + ")";
    }

    protected void extraValidation(List<Throwable> validationErrors, Configuration config) {
    }
}

