/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map.scalebar;

import com.google.common.collect.Lists;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRException;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.jasper.ImagesSubReport;
import org.mapfish.print.processor.map.scalebar.CreateScalebarProcessor;
import org.mapfish.print.processor.map.scalebar.ScalebarGraphic;

public class CreateScalebarProcessor
extends AbstractProcessor<Input, Output> {
    protected CreateScalebarProcessor() {
        super(Output.class);
    }

    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
    }

    public final Input createInputParameter() {
        return new Input();
    }

    public final Output execute(Input values, Processor.ExecutionContext context) throws Exception {
        this.checkCancelState(context);
        URI scalebarGraphicFile = this.createScalebarGraphic(values);
        this.checkCancelState(context);
        String strScalebarSubReport = null;
        if (values.scalebar.isCreateSubReport()) {
            URI scalebarSubReport = this.createScalebarSubReport(values.tempTaskDirectory, values.scalebar.getSize(), (List)Lists.newArrayList((Object[])new URI[]{scalebarGraphicFile}), values.mapContext.getDPI());
            strScalebarSubReport = scalebarSubReport.toString();
        }
        return new Output(scalebarGraphicFile.toString(), strScalebarSubReport, null);
    }

    private URI createScalebarGraphic(Input values) throws IOException, ParserConfigurationException {
        ScalebarGraphic scalebar = new ScalebarGraphic();
        return scalebar.render(values.mapContext, values.scalebar, values.tempTaskDirectory, values.template);
    }

    private URI createScalebarSubReport(File printDirectory, Dimension size, List<URI> graphics, double dpi) throws IOException, JRException {
        ImagesSubReport subReport = new ImagesSubReport(graphics, size, dpi);
        File compiledReport = File.createTempFile("scalebar-report-", ".jasper", printDirectory);
        subReport.compile(compiledReport);
        return compiledReport.toURI();
    }
}

