/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map.scalebar;

import com.google.common.annotations.VisibleForTesting;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.batik.svggen.SVGGraphics2D;
import org.geotools.referencing.GeodeticCalculator;
import org.mapfish.print.ImageUtils;
import org.mapfish.print.attribute.ScalebarAttribute;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Template;
import org.mapfish.print.map.DistanceUnit;
import org.mapfish.print.map.Scale;
import org.mapfish.print.processor.map.CreateMapProcessor;
import org.mapfish.print.processor.map.scalebar.Label;
import org.mapfish.print.processor.map.scalebar.ScaleBarRenderSettings;
import org.mapfish.print.processor.map.scalebar.ScalebarDrawer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ScalebarGraphic {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScalebarGraphic.class);
    private static final int MAX_NUMBER_LAYOUTING_TRIES = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final URI render(MapfishMapContext mapContext, ScalebarAttribute.ScalebarAttributeValues scalebarParams, File tempFolder, Template template) throws IOException, ParserConfigurationException {
        double dpi = mapContext.getDPI();
        Rectangle paintArea = new Rectangle(mapContext.getMapSize());
        MapBounds bounds = mapContext.getBounds();
        DistanceUnit mapUnit = this.getUnit(bounds);
        Scale scale = bounds.getScale(paintArea, 72.0);
        double scaleDenominator = scale.getDenominator(scalebarParams.geodetic, bounds.getProjection(), dpi, bounds.getCenter());
        DistanceUnit scaleUnit = scalebarParams.getUnit();
        if (scaleUnit == null) {
            scaleUnit = mapUnit;
        }
        double maxLengthInPixel = scalebarParams.getOrientation().isHorizontal() ? (double)scalebarParams.getSize().width : (double)scalebarParams.getSize().height;
        double maxIntervalLengthInWorldUnits = DistanceUnit.PX.convertTo(maxLengthInPixel, scaleUnit) * scaleDenominator / (double)scalebarParams.intervals.intValue();
        double niceIntervalLengthInWorldUnits = ScalebarGraphic.getNearestNiceValue((double)maxIntervalLengthInWorldUnits, (DistanceUnit)scaleUnit, (boolean)scalebarParams.lockUnits);
        ScaleBarRenderSettings settings = new ScaleBarRenderSettings();
        settings.setParams(scalebarParams);
        settings.setMaxSize(scalebarParams.getSize());
        settings.setPadding(ScalebarGraphic.getPadding((ScaleBarRenderSettings)settings));
        File path = null;
        if (template.getConfiguration().renderAsSvg(scalebarParams.renderAsSvg)) {
            SVGGraphics2D graphics2D = CreateMapProcessor.getSvgGraphics((Dimension)scalebarParams.getSize());
            try {
                ScalebarGraphic.tryLayout((Graphics2D)graphics2D, (DistanceUnit)scaleUnit, (double)scaleDenominator, (double)niceIntervalLengthInWorldUnits, (ScaleBarRenderSettings)settings, (int)0);
                path = File.createTempFile("scalebar-graphic-", ".svg", tempFolder);
                CreateMapProcessor.saveSvgFile((SVGGraphics2D)graphics2D, (File)path);
            }
            finally {
                graphics2D.dispose();
            }
        }
        double dpiRatio = mapContext.getDPI() / 72.0;
        BufferedImage bufferedImage = new BufferedImage((int)Math.round((double)scalebarParams.getSize().width * dpiRatio), (int)Math.round((double)scalebarParams.getSize().height * dpiRatio), 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            AffineTransform saveAF = new AffineTransform(graphics2D.getTransform());
            graphics2D.scale(dpiRatio, dpiRatio);
            ScalebarGraphic.tryLayout((Graphics2D)graphics2D, (DistanceUnit)scaleUnit, (double)scaleDenominator, (double)niceIntervalLengthInWorldUnits, (ScaleBarRenderSettings)settings, (int)0);
            graphics2D.setTransform(saveAF);
            path = File.createTempFile("scalebar-graphic-", ".png", tempFolder);
            ImageUtils.writeImage((BufferedImage)bufferedImage, (String)"png", (File)path);
        }
        finally {
            graphics2D.dispose();
        }
        return path.toURI();
    }

    private DistanceUnit getUnit(MapBounds bounds) {
        GeodeticCalculator calculator = new GeodeticCalculator(bounds.getProjection());
        return DistanceUnit.fromString((String)calculator.getEllipsoid().getAxisUnit().toString());
    }

    private static void tryLayout(Graphics2D graphics2D, DistanceUnit scaleUnit, double scaleDenominator, double intervalLengthInWorldUnits, ScaleBarRenderSettings settings, int tryNumber) {
        float bottomLabelMargin;
        float topLabelMargin;
        float rightLabelMargin;
        float leftLabelMargin;
        if (tryNumber > 3) {
            LOGGER.error("layouting the scalebar failed (unit: " + scaleUnit.toString() + ", scale: " + scaleDenominator + ")");
            return;
        }
        ScalebarAttribute.ScalebarAttributeValues scalebarParams = settings.getParams();
        DistanceUnit intervalUnit = ScalebarGraphic.bestUnit((DistanceUnit)scaleUnit, (double)intervalLengthInWorldUnits, (boolean)scalebarParams.lockUnits);
        float intervalLengthInPixels = (float)scaleUnit.convertTo(intervalLengthInWorldUnits / scaleDenominator, DistanceUnit.PX);
        ArrayList<Label> labels = new ArrayList<Label>(scalebarParams.intervals + 1);
        Font font = new Font(scalebarParams.font, 0, ScalebarGraphic.getFontSize((ScaleBarRenderSettings)settings));
        FontRenderContext frc = new FontRenderContext(null, true, true);
        if (scalebarParams.intervals > 1 || scalebarParams.subIntervals.booleanValue()) {
            for (int i = 0; i <= scalebarParams.intervals; ++i) {
                String labelText = ScalebarGraphic.createLabelText((DistanceUnit)scaleUnit, (double)(intervalLengthInWorldUnits * (double)i), (DistanceUnit)intervalUnit);
                if (i == scalebarParams.intervals) {
                    labelText = labelText + intervalUnit;
                }
                TextLayout labelLayout = new TextLayout(labelText, font, frc);
                labels.add(new Label(intervalLengthInPixels * (float)i, labelLayout, graphics2D));
            }
            leftLabelMargin = ((Label)labels.get(0)).getRotatedWidth(scalebarParams.getLabelRotation()) / 2.0f;
            rightLabelMargin = ((Label)labels.get(labels.size() - 1)).getRotatedWidth(scalebarParams.getLabelRotation()) / 2.0f;
            topLabelMargin = ((Label)labels.get(0)).getRotatedHeight(scalebarParams.getLabelRotation()) / 2.0f;
            bottomLabelMargin = ((Label)labels.get(labels.size() - 1)).getRotatedHeight(scalebarParams.getLabelRotation()) / 2.0f;
        } else {
            String labelText = ScalebarGraphic.createLabelText((DistanceUnit)scaleUnit, (double)intervalLengthInWorldUnits, (DistanceUnit)intervalUnit) + intervalUnit;
            TextLayout labelLayout = new TextLayout(labelText, font, frc);
            Label label = new Label(intervalLengthInPixels / 2.0f, labelLayout, graphics2D);
            labels.add(label);
            rightLabelMargin = 0.0f;
            leftLabelMargin = 0.0f;
            topLabelMargin = 0.0f;
            bottomLabelMargin = 0.0f;
        }
        if (ScalebarGraphic.fitsAvailableSpace((ScalebarAttribute.ScalebarAttributeValues)scalebarParams, (float)intervalLengthInPixels, (float)leftLabelMargin, (float)rightLabelMargin, (float)topLabelMargin, (float)bottomLabelMargin, (ScaleBarRenderSettings)settings)) {
            settings.setLabels(labels);
            settings.setScaleUnit(scaleUnit);
            settings.setIntervalLengthInPixels(intervalLengthInPixels);
            settings.setIntervalLengthInWorldUnits(intervalLengthInWorldUnits);
            settings.setIntervalUnit(intervalUnit);
            settings.setLeftLabelMargin(leftLabelMargin);
            settings.setRightLabelMargin(rightLabelMargin);
            settings.setTopLabelMargin(topLabelMargin);
            settings.setBottomLabelMargin(bottomLabelMargin);
            ScalebarGraphic.doLayout((Graphics2D)graphics2D, (ScalebarAttribute.ScalebarAttributeValues)scalebarParams, (ScaleBarRenderSettings)settings);
        } else {
            double nextIntervalDistance = ScalebarGraphic.getNearestNiceValue((double)(intervalLengthInWorldUnits * 0.9), (DistanceUnit)scaleUnit, (boolean)scalebarParams.lockUnits);
            ScalebarGraphic.tryLayout((Graphics2D)graphics2D, (DistanceUnit)scaleUnit, (double)scaleDenominator, (double)nextIntervalDistance, (ScaleBarRenderSettings)settings, (int)(tryNumber + 1));
        }
    }

    private static boolean fitsAvailableSpace(ScalebarAttribute.ScalebarAttributeValues scalebarParams, float intervalWidthInPixels, float leftLabelMargin, float rightLabelMargin, float topLabelMargin, float bottomLabelMargin, ScaleBarRenderSettings settings) {
        if (scalebarParams.getOrientation().isHorizontal()) {
            return (float)scalebarParams.intervals.intValue() * intervalWidthInPixels + leftLabelMargin + rightLabelMargin + (float)(2 * settings.getPadding()) <= (float)settings.getMaxSize().width;
        }
        return (float)scalebarParams.intervals.intValue() * intervalWidthInPixels + topLabelMargin + bottomLabelMargin + (float)(2 * settings.getPadding()) <= (float)settings.getMaxSize().height;
    }

    private static void doLayout(Graphics2D graphics2d, ScalebarAttribute.ScalebarAttributeValues scalebarParams, ScaleBarRenderSettings settings) {
        Dimension maxLabelSize = ScalebarGraphic.getMaxLabelSize((ScaleBarRenderSettings)settings);
        int numSubIntervals = 1;
        if (scalebarParams.subIntervals.booleanValue()) {
            numSubIntervals = ScalebarGraphic.getNbSubIntervals((DistanceUnit)settings.getScaleUnit(), (double)settings.getIntervalLengthInWorldUnits(), (DistanceUnit)settings.getIntervalUnit());
        }
        settings.setBarSize(ScalebarGraphic.getBarSize((ScaleBarRenderSettings)settings));
        settings.setLabelDistance(ScalebarGraphic.getLabelDistance((ScaleBarRenderSettings)settings));
        settings.setLineWidth(ScalebarGraphic.getLineWidth((ScaleBarRenderSettings)settings));
        settings.setSize(ScalebarGraphic.getSize((ScalebarAttribute.ScalebarAttributeValues)scalebarParams, (ScaleBarRenderSettings)settings, (Dimension)maxLabelSize));
        settings.setMaxLabelSize(maxLabelSize);
        settings.setNumSubIntervals(numSubIntervals);
        ScalebarDrawer drawer = scalebarParams.getType().createDrawer(graphics2d, settings);
        drawer.draw();
    }

    @VisibleForTesting
    protected static Dimension getSize(ScalebarAttribute.ScalebarAttributeValues scalebarParams, ScaleBarRenderSettings settings, Dimension maxLabelSize) {
        float height;
        float width;
        if (scalebarParams.getOrientation().isHorizontal()) {
            width = (float)(2 * settings.getPadding()) + settings.getIntervalLengthInPixels() * (float)scalebarParams.intervals.intValue() + settings.getLeftLabelMargin() + settings.getRightLabelMargin();
            height = (float)(2 * settings.getPadding() + settings.getBarSize() + settings.getLabelDistance()) + Label.getRotatedHeight((Dimension)maxLabelSize, (float)scalebarParams.getLabelRotation());
        } else {
            width = (float)(2 * settings.getPadding() + settings.getLabelDistance() + settings.getBarSize()) + Label.getRotatedWidth((Dimension)maxLabelSize, (float)scalebarParams.getLabelRotation());
            height = (float)(2 * settings.getPadding()) + settings.getTopLabelMargin() + settings.getIntervalLengthInPixels() * (float)scalebarParams.intervals.intValue() + settings.getBottomLabelMargin();
        }
        return new Dimension((int)Math.ceil(width), (int)Math.ceil(height));
    }

    @VisibleForTesting
    protected static Dimension getMaxLabelSize(ScaleBarRenderSettings settings) {
        float maxLabelHeight = 0.0f;
        float maxLabelWidth = 0.0f;
        for (Label label : settings.getLabels()) {
            maxLabelHeight = Math.max(maxLabelHeight, label.getHeight());
            maxLabelWidth = Math.max(maxLabelWidth, label.getWidth());
        }
        return new Dimension((int)Math.ceil(maxLabelWidth), (int)Math.ceil(maxLabelHeight));
    }

    @VisibleForTesting
    protected static String createLabelText(DistanceUnit scaleUnit, double value, DistanceUnit intervalUnit) {
        double scaledValue = scaleUnit.convertTo(value, intervalUnit);
        String decimals = Double.toString(scaledValue = (double)(Math.round(scaledValue * 10000.0) / 10000L)).split("\\.")[1];
        if (Double.valueOf(decimals) == 0.0) {
            return Long.toString(Math.round(scaledValue));
        }
        return Double.toString(scaledValue);
    }

    private static DistanceUnit bestUnit(DistanceUnit scaleUnit, double intervalDistance, boolean lockUnits) {
        if (lockUnits) {
            return scaleUnit;
        }
        return DistanceUnit.getBestUnit((double)intervalDistance, (DistanceUnit)scaleUnit);
    }

    @VisibleForTesting
    protected static double getNearestNiceValue(double value, DistanceUnit scaleUnit, boolean lockUnits) {
        int digits;
        double pow10;
        DistanceUnit bestUnit = ScalebarGraphic.bestUnit((DistanceUnit)scaleUnit, (double)value, (boolean)lockUnits);
        double factor = scaleUnit.convertTo(1.0, bestUnit);
        double firstChar = value * factor / (pow10 = Math.pow(10.0, digits = (int)Math.floor(Math.log(value * factor) / Math.log(10.0))));
        int barLen = firstChar >= 10.0 ? 10 : (firstChar >= 5.0 ? 5 : (firstChar >= 2.0 ? 2 : 1));
        return (double)barLen * pow10 / factor;
    }

    private static int getNbSubIntervals(DistanceUnit scaleUnit, double intervalDistance, DistanceUnit intervalUnit) {
        double value = scaleUnit.convertTo(intervalDistance, intervalUnit);
        int digits = (int)(Math.log(value) / Math.log(10.0));
        double pow10 = Math.pow(10.0, digits);
        int firstChar = (int)(value / pow10);
        switch (firstChar) {
            case 1: {
                return 2;
            }
            case 2: {
                return 2;
            }
            case 5: {
                return 5;
            }
            case 10: {
                return 2;
            }
        }
        throw new RuntimeException("Invalid interval: " + value + intervalUnit + " (" + firstChar + ")");
    }

    private static int getFontSize(ScaleBarRenderSettings settings) {
        return settings.getParams().fontSize;
    }

    private static int getLineWidth(ScaleBarRenderSettings settings) {
        if (settings.getParams().lineWidth != null) {
            return settings.getParams().lineWidth;
        }
        if (settings.getParams().getOrientation().isHorizontal()) {
            return settings.getMaxSize().width / 150;
        }
        return settings.getMaxSize().height / 150;
    }

    @VisibleForTesting
    protected static int getBarSize(ScaleBarRenderSettings settings) {
        if (settings.getParams().barSize != null) {
            return settings.getParams().barSize;
        }
        if (settings.getParams().getOrientation().isHorizontal()) {
            return settings.getMaxSize().height / 4;
        }
        return settings.getMaxSize().width / 4;
    }

    @VisibleForTesting
    protected static int getLabelDistance(ScaleBarRenderSettings settings) {
        if (settings.getParams().labelDistance != null) {
            return settings.getParams().labelDistance;
        }
        if (settings.getParams().getOrientation().isHorizontal()) {
            return settings.getMaxSize().width / 40;
        }
        return settings.getMaxSize().height / 40;
    }

    private static int getPadding(ScaleBarRenderSettings settings) {
        if (settings.getParams().padding != null) {
            return settings.getParams().padding;
        }
        if (settings.getParams().getOrientation().isHorizontal()) {
            return settings.getMaxSize().width / 40;
        }
        return settings.getMaxSize().height / 40;
    }
}

