/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.fileloader;

import com.google.common.collect.Iterators;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import javax.servlet.ServletContext;
import org.mapfish.print.servlet.fileloader.AbstractFileConfigFileLoader;
import org.springframework.beans.factory.annotation.Autowired;

public final class ServletConfigFileLoader
extends AbstractFileConfigFileLoader {
    private static final String PREFIX = "servlet";
    private static final int PREFIX_LENGTH = "servlet://".length();
    @Autowired
    private ServletContext servletContext;

    protected Iterator<File> resolveFiles(URI fileURI) {
        if (fileURI.getScheme() != null && fileURI.getScheme().equals("file") && new File(fileURI).exists()) {
            return Iterators.singletonIterator((Object)new File(fileURI));
        }
        if (fileURI.toString().startsWith(PREFIX)) {
            String path = fileURI.toString().substring(PREFIX_LENGTH);
            String realPath = this.servletContext.getRealPath(path);
            if (realPath == null) {
                return Collections.emptyIterator();
            }
            return Iterators.singletonIterator((Object)new File(realPath));
        }
        return Collections.emptyIterator();
    }

    public String getUriScheme() {
        return PREFIX;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

