/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job.impl;

import java.net.URI;
import java.net.URISyntaxException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.servlet.job.PrintJobResult;
import org.mapfish.print.servlet.job.PrintJobStatus;
import org.mapfish.print.servlet.job.impl.PrintJobStatusImpl;

@Entity
@Table(name="print_job_results")
public class PrintJobResultImpl
implements PrintJobResult {
    @Column
    @Id
    private final String reportURI;
    @Column
    private final String mimeType;
    @Column
    private final String fileExtension;
    @Column
    private final String fileName;
    @OneToOne(targetEntity=PrintJobStatusImpl.class, fetch=FetchType.LAZY)
    @OnDelete(action=OnDeleteAction.CASCADE)
    @JoinColumn(name="referenceId", insertable=false, updatable=false)
    private PrintJobStatus status = null;
    @Column(insertable=true, updatable=true)
    private String referenceId;

    public PrintJobResultImpl() {
        this.reportURI = null;
        this.mimeType = null;
        this.fileExtension = null;
        this.fileName = null;
        this.referenceId = null;
    }

    public PrintJobResultImpl(URI reportURI, String fileName, String fileExtension, String mimeType, String referenceId) {
        this.reportURI = reportURI.toString();
        this.mimeType = mimeType;
        this.fileName = fileName;
        this.fileExtension = fileExtension;
        this.referenceId = referenceId;
    }

    public final URI getReportURI() {
        try {
            return this.reportURI == null ? null : new URI(this.reportURI);
        }
        catch (URISyntaxException e) {
            throw ExceptionUtils.getRuntimeException((Throwable)e);
        }
    }

    public final String getReportURIString() {
        return this.reportURI;
    }

    public final String getMimeType() {
        return this.mimeType;
    }

    public final String getFileExtension() {
        return this.fileExtension;
    }

    public final String getFileName() {
        return this.fileName;
    }
}

