/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job.impl;

import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Target;
import org.mapfish.print.config.access.AccessAssertion;
import org.mapfish.print.servlet.job.PrintJobEntry;
import org.mapfish.print.servlet.job.PrintJobResult;
import org.mapfish.print.servlet.job.PrintJobStatus;
import org.mapfish.print.servlet.job.impl.PrintJobEntryImpl;
import org.mapfish.print.servlet.job.impl.PrintJobResultImpl;

@Entity
@Table(name="print_job_statuses")
public class PrintJobStatusImpl
implements PrintJobStatus {
    private static final int LENGTH_ERROR = 1024;
    @Id
    private String referenceId;
    @Embedded
    @Target(value=PrintJobEntryImpl.class)
    private final PrintJobEntry entry;
    @Column
    @Enumerated(value=EnumType.STRING)
    private PrintJobStatus.Status status = PrintJobStatus.Status.WAITING;
    @Column
    private Long completionTime;
    @Column
    private long requestCount;
    @Column(length=1024)
    private String error;
    @OneToOne(targetEntity=PrintJobResultImpl.class, cascade={CascadeType.ALL}, mappedBy="status")
    @JoinColumn(name="reference_id")
    private PrintJobResult result;
    private transient long waitingTime;
    private transient Long statusTime;

    public PrintJobStatusImpl() {
        this.entry = null;
    }

    public PrintJobStatusImpl(PrintJobEntry entry, long requestCount) {
        this.referenceId = entry.getReferenceId();
        this.entry = entry;
        this.requestCount = requestCount;
    }

    public final PrintJobEntry getEntry() {
        return this.entry;
    }

    public final void setCompletionTime(Long completionTime) {
        this.completionTime = completionTime;
    }

    public final Long getCompletionTime() {
        return this.completionTime;
    }

    public final long getRequestCount() {
        return this.requestCount;
    }

    public final String getError() {
        return this.error;
    }

    public final PrintJobStatus.Status getStatus() {
        return this.status;
    }

    public final void setStatus(PrintJobStatus.Status status) {
        this.status = status;
    }

    public final void setRequestCount(long requestCount) {
        this.requestCount = requestCount;
    }

    public final void setError(String error) {
        this.error = error;
    }

    public final PrintJobResult getResult() {
        return this.result;
    }

    public final void setResult(PrintJobResult result) {
        this.result = result;
    }

    public final String getReferenceId() {
        return this.referenceId;
    }

    public final long getStartTime() {
        return this.getEntry().getStartTime();
    }

    public final AccessAssertion getAccess() {
        return this.getEntry().getAccess();
    }

    public final String getAppId() {
        return this.getEntry().getAppId();
    }

    public final Date getStartDate() {
        return this.getEntry().getStartDate();
    }

    public final Date getCompletionDate() {
        return this.getCompletionTime() == null ? null : new Date(this.getCompletionTime());
    }

    public final long getElapsedTime() {
        if (this.completionTime != null) {
            return this.completionTime - this.getEntry().getStartTime();
        }
        if (this.statusTime != null) {
            return this.statusTime - this.getEntry().getStartTime();
        }
        return System.currentTimeMillis() - this.getEntry().getStartTime();
    }

    public final boolean isDone() {
        return this.getStatus() != PrintJobStatus.Status.RUNNING && this.getStatus() != PrintJobStatus.Status.WAITING;
    }

    public final long getWaitingTime() {
        return this.waitingTime;
    }

    public final void setWaitingTime(long waitingTime) {
        this.waitingTime = waitingTime;
    }

    public final Long getStatusTime() {
        return this.statusTime;
    }

    public final void setStatusTime(Long statusTime) {
        this.statusTime = statusTime;
    }
}

