/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.config.access.AccessAssertion;
import org.mapfish.print.config.access.AccessAssertionPersister;
import org.mapfish.print.servlet.job.JobQueue;
import org.mapfish.print.servlet.job.NoSuchReferenceException;
import org.mapfish.print.servlet.job.PrintJobEntry;
import org.mapfish.print.servlet.job.PrintJobResult;
import org.mapfish.print.servlet.job.PrintJobStatus;
import org.mapfish.print.servlet.job.impl.PrintJobEntryImpl;
import org.mapfish.print.servlet.job.impl.PrintJobResultImpl;
import org.mapfish.print.servlet.job.impl.PrintJobStatusImpl;
import org.mapfish.print.servlet.registry.Registry;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class RegistryJobQueue
implements JobQueue {
    private static final String NEW_PRINT_COUNT = "newPrintCount";
    private static final String LAST_PRINT_COUNT = "lastPrintCount";
    private static final String TOTAL_PRINT_TIME = "totalPrintTime";
    private static final String NB_PRINT_DONE = "nbPrintDone";
    private static final String LAST_POLL = "lastPoll_";
    private static final String RESULT_METADATA = "resultMetadata_";
    private static final String JSON_REQUEST_DATA = "requestData";
    private static final String JSON_FILENAME = "fileName";
    private static final String JSON_STATUS = "status";
    private static final String JSON_ACCESS_ASSERTION = "access";
    private static final String JSON_START_DATE = "startDate";
    private static final String JSON_COMPLETION_DATE = "completionDate";
    private static final String JSON_REQUEST_COUNT = "requestCount";
    private static final String JSON_ERROR = "errorMessage";
    private static final String JSON_REPORT_URI = "reportURI";
    private static final String JSON_MIME_TYPE = "mimeType";
    private static final String JSON_FILE_EXT = "fileExtension";
    @Autowired
    private Registry registry;
    @Qualifier(value="accessAssertionPersister")
    @Autowired
    private AccessAssertionPersister assertionPersister;

    public final long getTimeToKeepAfterAccessInMillis() {
        return this.registry.getTimeToKeepAfterAccessInMillis();
    }

    public final synchronized void add(PrintJobEntry jobEntry) {
        this.registry.incrementInt(NEW_PRINT_COUNT, 1);
        try {
            this.store((PrintJobStatus)new PrintJobStatusImpl(jobEntry, (long)this.getNumberOfRequestsMade()));
        }
        catch (JSONException e) {
            throw ExceptionUtils.getRuntimeException((Throwable)e);
        }
        this.registry.put(LAST_POLL + jobEntry.getReferenceId(), (Number)System.currentTimeMillis());
    }

    public final synchronized void start(String referenceId) throws NoSuchReferenceException {
        try {
            PrintJobStatusImpl jobStatus = this.load(referenceId);
            if (jobStatus.getStatus() == PrintJobStatus.Status.WAITING) {
                jobStatus.setStatus(PrintJobStatus.Status.RUNNING);
                jobStatus.setWaitingTime(0L);
                this.store((PrintJobStatus)jobStatus);
            }
        }
        catch (JSONException e) {
            throw ExceptionUtils.getRuntimeException((Throwable)e);
        }
    }

    public final synchronized void done(String referenceId, PrintJobResult result) throws NoSuchReferenceException {
        try {
            PrintJobStatusImpl status = this.load(referenceId);
            if (!status.isDone()) {
                this.registry.incrementInt(NB_PRINT_DONE, 1);
                this.registry.incrementLong(TOTAL_PRINT_TIME, status.getElapsedTime());
                this.registry.incrementInt(LAST_PRINT_COUNT, 1);
            }
            status.setCompletionTime(Long.valueOf(System.currentTimeMillis()));
            status.setStatus(PrintJobStatus.Status.FINISHED);
            status.setResult(result);
            this.store((PrintJobStatus)status);
        }
        catch (JSONException e) {
            throw ExceptionUtils.getRuntimeException((Throwable)e);
        }
    }

    public final synchronized void cancel(String referenceId, String message, boolean forceFinal) throws NoSuchReferenceException {
        try {
            PrintJobStatusImpl status = this.load(referenceId);
            if (!forceFinal && status.getStatus() == PrintJobStatus.Status.RUNNING) {
                status.setStatus(PrintJobStatus.Status.CANCELING);
            } else {
                if (!status.isDone()) {
                    this.registry.incrementInt(NB_PRINT_DONE, 1);
                    this.registry.incrementLong(TOTAL_PRINT_TIME, status.getElapsedTime());
                    this.registry.incrementInt(LAST_PRINT_COUNT, 1);
                }
                status.setCompletionTime(Long.valueOf(System.currentTimeMillis()));
                status.setStatus(PrintJobStatus.Status.CANCELLED);
            }
            status.setError(message);
            this.store((PrintJobStatus)status);
        }
        catch (JSONException e) {
            throw ExceptionUtils.getRuntimeException((Throwable)e);
        }
    }

    public final synchronized void fail(String referenceId, String message) throws NoSuchReferenceException {
        try {
            PrintJobStatusImpl status = this.load(referenceId);
            if (!status.isDone()) {
                this.registry.incrementInt(NB_PRINT_DONE, 1);
                this.registry.incrementLong(TOTAL_PRINT_TIME, status.getElapsedTime());
                this.registry.incrementInt(LAST_PRINT_COUNT, 1);
            }
            status.setCompletionTime(Long.valueOf(System.currentTimeMillis()));
            status.setStatus(PrintJobStatus.Status.ERROR);
            status.setError(message);
            this.store((PrintJobStatus)status);
        }
        catch (JSONException e) {
            throw ExceptionUtils.getRuntimeException((Throwable)e);
        }
    }

    public final int getNumberOfRequestsMade() {
        return (Integer)this.registry.opt(NEW_PRINT_COUNT, (Object)0);
    }

    public final long timeSinceLastStatusCheck(String referenceId) {
        long lastPoll = (Long)this.registry.opt(LAST_POLL + referenceId, (Object)0L);
        if (lastPoll == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - lastPoll;
    }

    public final long getAverageTimeSpentPrinting() {
        return (Long)this.registry.opt(TOTAL_PRINT_TIME, (Object)0L) / ((Integer)this.registry.opt(NB_PRINT_DONE, (Object)1)).longValue();
    }

    public final int getLastPrintCount() {
        return (Integer)this.registry.opt(LAST_PRINT_COUNT, (Object)0);
    }

    public final int getWaitingJobsCount() {
        return this.getNumberOfRequestsMade() - this.getLastPrintCount();
    }

    public final PrintJobStatusImpl get(String referenceId, boolean external) throws NoSuchReferenceException {
        try {
            PrintJobStatusImpl status = this.load(referenceId);
            status.setStatusTime(Long.valueOf(System.currentTimeMillis()));
            if (!status.isDone() && external) {
                this.registry.put(LAST_POLL + referenceId, (Number)System.currentTimeMillis());
            }
            return status;
        }
        catch (JSONException e) {
            throw ExceptionUtils.getRuntimeException((Throwable)e);
        }
    }

    private void store(PrintJobStatus printJobStatus) throws JSONException {
        JSONObject metadata = new JSONObject();
        metadata.put(JSON_REQUEST_DATA, (Object)printJobStatus.getEntry().getRequestData().getInternalObj());
        metadata.put(JSON_STATUS, (Object)printJobStatus.getStatus().toString());
        metadata.put(JSON_START_DATE, printJobStatus.getStartTime());
        metadata.put(JSON_REQUEST_COUNT, printJobStatus.getRequestCount());
        if (printJobStatus.getCompletionDate() != null) {
            metadata.put(JSON_COMPLETION_DATE, (Object)printJobStatus.getCompletionTime());
        }
        metadata.put(JSON_ACCESS_ASSERTION, (Object)this.assertionPersister.marshal(printJobStatus.getAccess()));
        if (printJobStatus.getError() != null) {
            metadata.put(JSON_ERROR, (Object)printJobStatus.getError());
        }
        if (printJobStatus.getResult() != null) {
            metadata.put(JSON_REPORT_URI, (Object)printJobStatus.getResult().getReportURIString());
            metadata.put(JSON_FILENAME, (Object)printJobStatus.getResult().getFileName());
            metadata.put(JSON_FILE_EXT, (Object)printJobStatus.getResult().getFileExtension());
            metadata.put(JSON_MIME_TYPE, (Object)printJobStatus.getResult().getMimeType());
        }
        this.registry.put(RESULT_METADATA + printJobStatus.getReferenceId(), metadata);
    }

    private PrintJobStatusImpl load(String referenceId) throws JSONException, NoSuchReferenceException {
        if (this.registry.containsKey(RESULT_METADATA + referenceId)) {
            JSONObject metadata = this.registry.getJSON(RESULT_METADATA + referenceId);
            PrintJobStatus.Status status = PrintJobStatus.Status.valueOf((String)metadata.getString(JSON_STATUS));
            PJsonObject requestData = new PJsonObject(metadata.getJSONObject(JSON_REQUEST_DATA), "spec");
            Long startTime = metadata.getLong(JSON_START_DATE);
            long requestCount = metadata.getLong(JSON_REQUEST_COUNT);
            JSONObject accessJSON = metadata.getJSONObject(JSON_ACCESS_ASSERTION);
            AccessAssertion accessAssertion = this.assertionPersister.unmarshal(accessJSON);
            PrintJobStatusImpl report = new PrintJobStatusImpl((PrintJobEntry)new PrintJobEntryImpl(referenceId, requestData, startTime.longValue(), accessAssertion), requestCount);
            report.setStatus(status);
            if (metadata.has(JSON_COMPLETION_DATE)) {
                report.setCompletionTime(Long.valueOf(metadata.getLong(JSON_COMPLETION_DATE)));
            }
            if (metadata.has(JSON_ERROR)) {
                report.setError(metadata.getString(JSON_ERROR));
            }
            if (metadata.has(JSON_REPORT_URI)) {
                URI reportURI;
                try {
                    reportURI = new URI(metadata.getString(JSON_REPORT_URI));
                }
                catch (URISyntaxException e) {
                    throw ExceptionUtils.getRuntimeException((Throwable)e);
                }
                String fileName = metadata.getString(JSON_FILENAME);
                String fileExt = metadata.getString(JSON_FILE_EXT);
                String mimeType = metadata.getString(JSON_MIME_TYPE);
                PrintJobResultImpl result = new PrintJobResultImpl(reportURI, fileName, fileExt, mimeType, referenceId);
                report.setResult((PrintJobResult)result);
            }
            return report;
        }
        throw new NoSuchReferenceException(referenceId);
    }

    public final void cancelOld(long startTimeOut, long abandonTimeout, String message) {
        throw new UnsupportedOperationException();
    }

    public final List<? extends PrintJobStatus> start(int number) {
        throw new UnsupportedOperationException();
    }

    public final List<? extends PrintJobStatus> toCancel() {
        throw new UnsupportedOperationException();
    }
}

