/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.config.WorkingDirectories;
import org.mapfish.print.servlet.job.JobManager;
import org.mapfish.print.servlet.job.JobQueue;
import org.mapfish.print.servlet.job.NoSuchReferenceException;
import org.mapfish.print.servlet.job.PrintJob;
import org.mapfish.print.servlet.job.PrintJobEntry;
import org.mapfish.print.servlet.job.PrintJobResult;
import org.mapfish.print.servlet.job.PrintJobStatus;
import org.mapfish.print.servlet.job.impl.SubmittedPrintJob;
import org.mapfish.print.servlet.job.impl.ThreadPoolJobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.security.core.context.SecurityContextHolder;

public class ThreadPoolJobManager
implements JobManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadPoolJobManager.class);
    private static final int DEFAULT_MAX_WAITING_JOBS = 5000;
    private static final long DEFAULT_THREAD_IDLE_TIME = 60L;
    private static final long DEFAULT_TIMEOUT_IN_SECONDS = 600L;
    private static final long DEFAULT_ABANDONED_TIMEOUT_IN_SECONDS = 120L;
    private static final boolean DEFAULT_OLD_FILES_CLEAN_UP = true;
    private static final long DEFAULT_CLEAN_UP_INTERVAL_IN_SECONDS = 86400L;
    private int maxNumberOfRunningPrintJobs = Runtime.getRuntime().availableProcessors();
    private int maxNumberOfWaitingJobs = 5000;
    private long maxIdleTime = 60L;
    private long timeout = 600L;
    private long abandonedTimeout = 120L;
    private boolean oldFileCleanUp = true;
    private long oldFileCleanupInterval = 86400L;
    private boolean clustered = false;
    private Comparator<PrintJob> jobPriorityComparator = new /* Unavailable Anonymous Inner Class!! */;
    private ThreadPoolExecutor executor;
    private final Map<String, SubmittedPrintJob> runningTasksFutures = Collections.synchronizedMap(new HashMap());
    private ScheduledExecutorService timer;
    private ScheduledExecutorService cleanUpTimer;
    @Autowired
    private WorkingDirectories workingDirectories;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private JobQueue jobQueue;

    public final void setMaxNumberOfRunningPrintJobs(int maxNumberOfRunningPrintJobs) {
        this.maxNumberOfRunningPrintJobs = maxNumberOfRunningPrintJobs;
    }

    public final void setMaxNumberOfWaitingJobs(int maxNumberOfWaitingJobs) {
        this.maxNumberOfWaitingJobs = maxNumberOfWaitingJobs;
    }

    public final void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public final void setAbandonedTimeout(long abandonedTimeout) {
        this.abandonedTimeout = abandonedTimeout;
    }

    public final void setJobPriorityComparator(Comparator<PrintJob> jobPriorityComparator) {
        this.jobPriorityComparator = jobPriorityComparator;
    }

    public final void setOldFileCleanUp(boolean oldFileCleanUp) {
        this.oldFileCleanUp = oldFileCleanUp;
    }

    public final void setOldFileCleanupInterval(long oldFileCleanupInterval) {
        this.oldFileCleanupInterval = oldFileCleanupInterval;
    }

    public final void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    protected final void initForTesting(ApplicationContext appContext) {
        this.context = appContext;
        this.workingDirectories = (WorkingDirectories)this.context.getBean(WorkingDirectories.class);
        this.jobQueue = (JobQueue)this.context.getBean(JobQueue.class);
        this.init();
    }

    @PostConstruct
    public final void init() {
        long timeToKeepAfterAccessInMillis = this.jobQueue.getTimeToKeepAfterAccessInMillis();
        if (timeToKeepAfterAccessInMillis >= 0L) {
            if (TimeUnit.SECONDS.toMillis(this.abandonedTimeout) >= this.jobQueue.getTimeToKeepAfterAccessInMillis()) {
                String msg = String.format("%s abandonTimeout must be smaller than %s timeToKeepAfterAccess", this.getClass().getName(), this.jobQueue.getClass().getName());
                throw new IllegalStateException(msg);
            }
            if (TimeUnit.SECONDS.toMillis(this.timeout) >= this.jobQueue.getTimeToKeepAfterAccessInMillis()) {
                String msg = String.format("%s timeout must be smaller than %s timeToKeepAfterAccess", this.getClass().getName(), this.jobQueue.getClass().getName());
                throw new IllegalStateException(msg);
            }
        }
        CustomizableThreadFactory threadFactory = new CustomizableThreadFactory();
        threadFactory.setDaemon(true);
        threadFactory.setThreadNamePrefix("PrintJobManager-");
        PriorityBlockingQueue queue = new PriorityBlockingQueue(this.maxNumberOfWaitingJobs, new /* Unavailable Anonymous Inner Class!! */);
        this.executor = new /* Unavailable Anonymous Inner Class!! */;
        this.timer = Executors.newScheduledThreadPool(1, (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);
        this.timer.scheduleAtFixedRate((Runnable)new RegistryTask(this), 500L, 500L, TimeUnit.MILLISECONDS);
        if (this.oldFileCleanUp) {
            this.cleanUpTimer = Executors.newScheduledThreadPool(1, (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);
            this.cleanUpTimer.scheduleAtFixedRate(this.workingDirectories.getCleanUpTask(), 0L, this.oldFileCleanupInterval, TimeUnit.SECONDS);
        }
    }

    @PreDestroy
    public final void shutdown() {
        this.timer.shutdownNow();
        this.executor.shutdownNow();
        if (this.cleanUpTimer != null) {
            this.cleanUpTimer.shutdownNow();
        }
    }

    private void executeJob(PrintJob job) {
        Future future = this.executor.submit(job);
        this.runningTasksFutures.put(job.getEntry().getReferenceId(), new SubmittedPrintJob(future, job.getEntry()));
    }

    protected PrintJob createJob(PrintJobEntry entry) {
        PrintJob job = (PrintJob)this.context.getBean(PrintJob.class);
        job.setEntry(entry);
        job.setSecurityContext(SecurityContextHolder.getContext());
        return job;
    }

    private void submitInternal(PrintJobEntry jobEntry) {
        int numberOfWaitingRequests = this.jobQueue.getWaitingJobsCount();
        if (numberOfWaitingRequests >= this.maxNumberOfWaitingJobs) {
            throw new RuntimeException("Max. number of waiting print job requests exceeded.  Number of waiting requests are: " + numberOfWaitingRequests);
        }
        jobEntry.assertAccess();
        this.jobQueue.add(jobEntry);
        LOGGER.info("Submitted print job " + jobEntry.getReferenceId());
    }

    public final void submit(PrintJob job) {
        try {
            this.submitInternal(job.getEntry());
        }
        finally {
            this.executeJob(job);
        }
    }

    public final void submit(PrintJobEntry entry) {
        try {
            this.submitInternal(entry);
        }
        finally {
            if (!this.clustered) {
                this.executeJob(this.createJob(entry));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelJobIfRunning(String referenceId) throws NoSuchReferenceException {
        Map map = this.runningTasksFutures;
        synchronized (map) {
            if (this.runningTasksFutures.containsKey(referenceId)) {
                SubmittedPrintJob printJob = (SubmittedPrintJob)this.runningTasksFutures.get(referenceId);
                printJob.getEntry().assertAccess();
                if (!printJob.getReportFuture().cancel(true)) {
                    LOGGER.info("Could not cancel job " + referenceId);
                }
                this.runningTasksFutures.remove(referenceId);
                this.jobQueue.cancel(referenceId, "task cancelled", true);
            }
        }
    }

    public final void cancel(String referenceId) throws NoSuchReferenceException {
        this.jobQueue.cancel(referenceId, "task cancelled", false);
        this.cancelJobIfRunning(referenceId);
    }

    public final PrintJobStatus getStatus(String referenceId) throws NoSuchReferenceException {
        PrintJobStatus jobStatus = this.jobQueue.get(referenceId, true);
        jobStatus.getEntry().assertAccess();
        if (jobStatus.getStatus() == PrintJobStatus.Status.WAITING) {
            long requestsMadeAtStart = jobStatus.getRequestCount();
            long finishedJobs = this.jobQueue.getLastPrintCount();
            long jobsRunningOrInQueue = requestsMadeAtStart - finishedJobs;
            long jobsInQueue = jobsRunningOrInQueue - (long)this.maxNumberOfRunningPrintJobs;
            long queuePosition = jobsInQueue / (long)this.maxNumberOfRunningPrintJobs;
            jobStatus.setWaitingTime(Math.max(0L, queuePosition * this.jobQueue.getAverageTimeSpentPrinting()));
        }
        return jobStatus;
    }

    private void cancelOld() {
        this.jobQueue.cancelOld(TimeUnit.MILLISECONDS.convert(this.timeout, TimeUnit.SECONDS), TimeUnit.MILLISECONDS.convert(this.abandonedTimeout, TimeUnit.SECONDS), "task cancelled (timeout)");
    }

    private void pollRegistry() {
        for (PrintJobStatus stat : this.jobQueue.toCancel()) {
            try {
                this.cancelJobIfRunning(stat.getReferenceId());
            }
            catch (NoSuchReferenceException e) {
                throw ExceptionUtils.getRuntimeException((Throwable)e);
            }
        }
        if (this.runningTasksFutures.size() < this.maxNumberOfRunningPrintJobs) {
            for (PrintJobStatus stat : this.jobQueue.start(this.maxNumberOfRunningPrintJobs - this.runningTasksFutures.size())) {
                this.executeJob(this.createJob(stat.getEntry()));
            }
        }
    }

    private void updateRegistry() {
        Iterator submittedJobs = this.runningTasksFutures.values().iterator();
        while (submittedJobs.hasNext()) {
            SubmittedPrintJob printJob = (SubmittedPrintJob)submittedJobs.next();
            if (!printJob.getReportFuture().isDone() && (this.isTimeoutExceeded(printJob) || this.isAbandoned(printJob))) {
                LOGGER.info("Cancelling job after timeout " + printJob.getEntry().getReferenceId());
                if (!printJob.getReportFuture().cancel(true)) {
                    LOGGER.info("Could not cancel job after timeout " + printJob.getEntry().getReferenceId());
                }
                this.executor.purge();
            }
            if (!printJob.getReportFuture().isDone()) continue;
            submittedJobs.remove();
            try {
                try {
                    this.jobQueue.done(printJob.getEntry().getReferenceId(), (PrintJobResult)printJob.getReportFuture().get());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    this.jobQueue.fail(printJob.getEntry().getReferenceId(), ExceptionUtils.getRootCause((Throwable)e).toString());
                }
                catch (CancellationException e) {
                    this.jobQueue.cancel(printJob.getEntry().getReferenceId(), "task cancelled (timeout)", true);
                }
            }
            catch (NoSuchReferenceException e) {
                throw ExceptionUtils.getRuntimeException((Throwable)e);
            }
        }
    }

    private boolean isTimeoutExceeded(SubmittedPrintJob printJob) {
        return printJob.getEntry().getTimeSinceStart() > TimeUnit.MILLISECONDS.convert(this.timeout, TimeUnit.SECONDS);
    }

    private boolean isAbandoned(SubmittedPrintJob printJob) {
        boolean abandoned;
        long duration = this.jobQueue.timeSinceLastStatusCheck(printJob.getEntry().getReferenceId());
        boolean bl = abandoned = duration > TimeUnit.SECONDS.toMillis(this.abandonedTimeout);
        if (abandoned) {
            LOGGER.info("Job " + printJob.getEntry().getReferenceId() + " is abandoned (no status check within the last " + this.abandonedTimeout + " seconds)");
        }
        return abandoned;
    }

    static /* synthetic */ Comparator access$000(ThreadPoolJobManager x0) {
        return x0.jobPriorityComparator;
    }

    static /* synthetic */ boolean access$100(ThreadPoolJobManager x0) {
        return x0.clustered;
    }

    static /* synthetic */ JobQueue access$200(ThreadPoolJobManager x0) {
        return x0.jobQueue;
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }

    static /* synthetic */ ThreadPoolExecutor access$400(ThreadPoolJobManager x0) {
        return x0.executor;
    }

    static /* synthetic */ Map access$500(ThreadPoolJobManager x0) {
        return x0.runningTasksFutures;
    }

    static /* synthetic */ void access$600(ThreadPoolJobManager x0) {
        x0.updateRegistry();
    }

    static /* synthetic */ void access$700(ThreadPoolJobManager x0) {
        x0.cancelOld();
    }

    static /* synthetic */ void access$800(ThreadPoolJobManager x0) {
        x0.pollRegistry();
    }
}

