/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.wrapper;

import org.mapfish.print.wrapper.PArray;
import org.mapfish.print.wrapper.PObject;

public final class PJoinedArray
implements PArray {
    private final PArray[] arrays;
    private final int combinedSize;

    public PJoinedArray(PArray[] arrays) {
        this.arrays = arrays;
        int size = 0;
        for (PArray array : arrays) {
            size += array.size();
        }
        this.combinedSize = size;
    }

    public int size() {
        return this.combinedSize;
    }

    public PObject getObject(int i) {
        int index = i;
        for (PArray array : this.arrays) {
            if (index < array.size()) {
                return array.getObject(index);
            }
            index -= array.size();
        }
        return null;
    }

    public PArray getArray(int i) {
        int index = i;
        for (PArray array : this.arrays) {
            if (index < array.size()) {
                return array.getArray(index);
            }
            index -= array.size();
        }
        return null;
    }

    public int getInt(int i) {
        return (Integer)this.get(i);
    }

    public long getLong(int i) {
        return (Long)this.get(i);
    }

    public float getFloat(int i) {
        return ((Float)this.get(i)).floatValue();
    }

    public double getDouble(int i) {
        return (Double)this.get(i);
    }

    public String getString(int i) {
        return this.get(i).toString();
    }

    public boolean getBool(int i) {
        return (Boolean)this.get(i);
    }

    public String getPath(String key) {
        StringBuilder builder = new StringBuilder();
        for (PArray array : this.arrays) {
            if (builder.length() == 0) {
                builder.append(" + ");
            }
            builder.append(array.getPath(key));
        }
        return "Merged: " + builder;
    }

    public String getCurrentPath() {
        StringBuilder builder = new StringBuilder();
        for (PArray array : this.arrays) {
            if (builder.length() == 0) {
                builder.append(" + ");
            }
            builder.append(array.getCurrentPath());
        }
        return "Merged: " + builder;
    }

    public Object get(int i) {
        int index = i;
        for (PArray array : this.arrays) {
            if (index < array.size()) {
                return array.get(index);
            }
            index -= array.size();
        }
        return null;
    }
}

