/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.wrapper.yaml;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.wrapper.PAbstractObject;
import org.mapfish.print.wrapper.PArray;
import org.mapfish.print.wrapper.PElement;
import org.mapfish.print.wrapper.PObject;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.mapfish.print.wrapper.yaml.PYamlArray;

public class PYamlObject
extends PAbstractObject {
    private final Map<String, Object> obj;

    public PYamlObject(Map<String, Object> obj, String contextName) {
        this(null, obj, contextName);
    }

    public PYamlObject(PElement parent, Map<String, Object> obj, String contextName) {
        super(parent, contextName);
        this.obj = obj;
    }

    public final Object opt(String key) {
        Object value = this.obj.get(key);
        if (value instanceof Map) {
            return new PYamlObject((PElement)this, (Map)value, key);
        }
        if (value instanceof List) {
            return new PYamlArray((PElement)this, (List)value, key);
        }
        if (value != null && value.getClass().isArray()) {
            return new PYamlArray((PElement)this, Arrays.asList((Object[])value), key);
        }
        return value;
    }

    public final String optString(String key) {
        Object value = this.obj.get(key);
        if (value == null || value instanceof String) {
            return (String)value;
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value).toString();
        }
        if (value instanceof Collection) {
            return new JSONArray((Collection)value).toString();
        }
        return value.toString();
    }

    public final Integer optInt(String key) {
        return (Integer)this.obj.get(key);
    }

    public final Long optLong(String key) {
        return (Long)this.obj.get(key);
    }

    public final Double optDouble(String key) {
        Number result = (Number)this.obj.get(key);
        return result == null ? null : Double.valueOf(result.doubleValue());
    }

    public final Float optFloat(String key) {
        Number result = (Number)this.obj.get(key);
        return result == null ? null : Float.valueOf(result.floatValue());
    }

    public final Boolean optBool(String key) {
        return (Boolean)this.obj.get(key);
    }

    public final PObject optObject(String key) {
        Map val = (Map)this.obj.get(key);
        return val == null ? null : new PYamlObject((PElement)this, val, key);
    }

    public final PArray optArray(String key) {
        List val = (List)this.obj.get(key);
        return val == null ? null : new PYamlArray((PElement)this, val, key);
    }

    public final boolean isArray(String key) {
        return this.obj.get(key) instanceof List;
    }

    public final Iterator<String> keys() {
        return this.obj.keySet().iterator();
    }

    public final int size() {
        return this.obj.keySet().size();
    }

    public final boolean has(String key) {
        return this.obj.containsKey(key);
    }

    public final String toString() {
        try {
            return "PYaml(" + this.getCurrentPath() + ":" + this.toJSON().getInternalObj().toString(2) + ")";
        }
        catch (JSONException e) {
            throw ExceptionUtils.getRuntimeException((Throwable)e);
        }
    }

    public final PJsonObject toJSON() {
        try {
            JSONObject json = new JSONObject();
            for (String key : this.obj.keySet()) {
                Object opt = this.opt(key);
                if (opt instanceof PYamlObject) {
                    opt = ((PYamlObject)opt).toJSON().getInternalObj();
                } else if (opt instanceof PYamlArray) {
                    opt = ((PYamlArray)opt).toJSON().getInternalArray();
                }
                json.put(key, opt);
            }
            return new PJsonObject(json, this.getContextName());
        }
        catch (Throwable e) {
            throw ExceptionUtils.getRuntimeException((Throwable)e);
        }
    }
}

