/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.IllegalFileAccessException;
import org.mapfish.print.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static URL testForLegalFileUrl(Configuration configuration, URL url) {
        String protocol = url.getProtocol();
        if (protocol.equalsIgnoreCase("file")) {
            try {
                File file = new File(configuration.getDirectory(), url.toExternalForm().substring("file://".length()));
                if (file.exists() && file.isFile()) {
                    URL tmpUrl = file.getAbsoluteFile().toURI().toURL();
                    FileUtils.assertFileIsInConfigDir((Configuration)configuration, (File)file);
                    return tmpUrl;
                }
                file = new File(url.getFile());
                if (file.exists() && file.isFile()) {
                    URL tmpUrl = file.getAbsoluteFile().toURI().toURL();
                    FileUtils.assertFileIsInConfigDir((Configuration)configuration, (File)file);
                    return tmpUrl;
                }
                throw new IllegalArgumentException("File urls must refer to a file within the configuration directory");
            }
            catch (MalformedURLException e) {
                throw ExceptionUtils.getRuntimeException((Throwable)e);
            }
        }
        return url;
    }

    public static void assertFileIsInConfigDir(Configuration configuration, File file) {
        FileUtils.assertIsSubDirectory((String)"configuration", (File)file, (File[])new File[]{configuration.getDirectory()});
    }

    public static boolean assertIsSubDirectory(String descriptorOfBase, File child, File ... baseFiles) {
        File canonicalChild;
        try {
            canonicalChild = child.getCanonicalFile();
        }
        catch (IOException e) {
            throw new Error("Unable to get the canonical file of '" + child + "'.  Therefore it is not possible to verify if it is a " + "child of '" + Arrays.toString(baseFiles) + "'.");
        }
        for (File base : baseFiles) {
            File canonicalBase;
            try {
                canonicalBase = base.getCanonicalFile();
            }
            catch (IOException e) {
                throw new Error("Unable to get the canonical file of '" + base + "'.  Therefore it is not possible to verify if '" + child + "' is a child of it.");
            }
            for (File parentFile = canonicalChild; parentFile != null; parentFile = parentFile.getParentFile()) {
                if (!canonicalBase.equals(parentFile)) continue;
                return true;
            }
        }
        LOGGER.warn("A user attempted to access a file not within the '" + descriptorOfBase + "' directories (" + Arrays.toString(baseFiles) + "). " + "Attempted access to :" + canonicalChild);
        throw new IllegalFileAccessException("'" + canonicalChild + "' identifies a file that is not within the '" + descriptorOfBase + "' directories: " + Arrays.toString(baseFiles));
    }
}

