/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute.map;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Rectangle;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.mapfish.print.attribute.map.GenericMapAttribute;
import org.mapfish.print.attribute.map.ZoomLevelSnapStrategy;
import org.mapfish.print.attribute.map.ZoomLevels;
import org.mapfish.print.map.DistanceUnit;
import org.mapfish.print.map.Scale;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MapBounds {
    private final CoordinateReferenceSystem projection;
    private static final Logger LOGGER = LoggerFactory.getLogger(MapBounds.class);

    protected MapBounds(CoordinateReferenceSystem projection) {
        this.projection = projection;
    }

    public abstract ReferencedEnvelope toReferencedEnvelope(Rectangle var1, double var2);

    public abstract MapBounds adjustedEnvelope(Rectangle var1);

    public final CoordinateReferenceSystem getProjection() {
        return this.projection;
    }

    public abstract MapBounds adjustBoundsToNearestScale(ZoomLevels var1, double var2, ZoomLevelSnapStrategy var4, boolean var5, Rectangle var6, double var7);

    public abstract Scale getScaleDenominator(Rectangle var1, double var2);

    public final Scale getGeodeticScaleDenominator(Rectangle paintArea, double dpi) {
        DistanceUnit projUnit = DistanceUnit.fromProjection((CoordinateReferenceSystem)this.getProjection());
        if (projUnit == DistanceUnit.DEGREES) {
            return this.getScaleDenominator(paintArea, dpi);
        }
        try {
            ReferencedEnvelope bboxAdjustedToScreen = this.toReferencedEnvelope(paintArea, dpi);
            GeodeticCalculator calculator = new GeodeticCalculator(this.getProjection());
            double centerY = bboxAdjustedToScreen.centre().y;
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)this.getProjection(), (CoordinateReferenceSystem)GenericMapAttribute.parseProjection((String)"EPSG:4326", (Boolean)true));
            Coordinate start = JTS.transform((Coordinate)new Coordinate(bboxAdjustedToScreen.getMinX(), centerY), null, (MathTransform)transform);
            Coordinate end = JTS.transform((Coordinate)new Coordinate(bboxAdjustedToScreen.getMaxX(), centerY), null, (MathTransform)transform);
            calculator.setStartingGeographicPoint(start.x, start.y);
            calculator.setDestinationGeographicPoint(end.x, end.y);
            double geoWidthInEllipsoidUnits = calculator.getOrthodromicDistance();
            DistanceUnit ellipsoidUnit = DistanceUnit.fromString((String)calculator.getEllipsoid().getAxisUnit().toString());
            double geoWidthInInches = ellipsoidUnit.convertTo(geoWidthInEllipsoidUnits, DistanceUnit.IN);
            return new Scale(geoWidthInInches * (dpi / paintArea.getWidth()));
        }
        catch (FactoryException e) {
            LOGGER.error("Unable to do the geodetic calculation on the scale", (Throwable)e);
        }
        catch (TransformException e) {
            LOGGER.error("Unable to do the geodetic calculation on the scale", (Throwable)e);
        }
        return this.getScaleDenominator(paintArea, dpi);
    }

    public abstract MapBounds adjustBoundsToRotation(double var1);

    public abstract MapBounds zoomOut(double var1);

    public abstract MapBounds zoomToScale(double var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapBounds mapBounds = (MapBounds)o;
        return this.projection.equals(mapBounds.projection);
    }

    public int hashCode() {
        return this.projection.hashCode();
    }
}

