/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute.map;

import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.config.ConfigurationObject;

public final class ZoomLevels
implements ConfigurationObject {
    private double[] scales;

    public ZoomLevels(double ... scales) {
        this.setScales(scales);
    }

    public ZoomLevels() {
    }

    public void setScales(double[] scales) {
        int i;
        TreeSet<Double> sortedSet = new TreeSet<Double>((Comparator<Double>)Ordering.natural().reverse());
        for (i = 0; i < scales.length; ++i) {
            sortedSet.add(scales[i]);
        }
        this.scales = new double[sortedSet.size()];
        i = 0;
        for (Double aDouble : sortedSet) {
            this.scales[i] = aDouble;
            ++i;
        }
    }

    public int size() {
        return this.scales.length;
    }

    public double get(int index) {
        return this.scales[index];
    }

    public String toString() {
        return Arrays.toString(this.scales);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZoomLevels that = (ZoomLevels)o;
        return Arrays.equals(this.scales, that.scales);
    }

    public int hashCode() {
        return Arrays.hashCode(this.scales);
    }

    public void validate(List<Throwable> validationErrors, Configuration configuration) {
        if (this.scales == null || this.scales.length == 0) {
            validationErrors.add((Throwable)new ConfigurationException("There are no scales defined in " + this.getClass().getName()));
        }
    }

    public double[] getScales() {
        double[] dest = new double[this.scales.length];
        System.arraycopy(this.scales, 0, dest, 0, this.scales.length);
        return dest;
    }
}

