/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config;

import com.google.common.base.Optional;
import java.util.List;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationObject;

public class PDFConfig
implements ConfigurationObject {
    private static final String MAPFISH_PRINT = "Mapfish Print";
    private Optional<Boolean> compressed = Optional.absent();
    private Optional<String> title = Optional.absent();
    private Optional<String> author = Optional.absent();
    private Optional<String> subject = Optional.absent();
    private Optional<String> keywords = Optional.absent();
    private Optional<String> creator = Optional.absent();

    PDFConfig getMergedInstance(PDFConfig other) {
        PDFConfig merged = new PDFConfig();
        merged.compressed = this.compressed.or(other.compressed);
        merged.title = this.title.or(other.title);
        merged.author = this.author.or(other.author);
        merged.subject = this.subject.or(other.subject);
        merged.keywords = this.keywords.or(other.keywords);
        merged.creator = this.creator.or(other.creator);
        return merged;
    }

    public void validate(List<Throwable> validationErrors, Configuration configuration) {
    }

    public boolean isCompressed() {
        return (Boolean)this.compressed.or((Object)false);
    }

    public void setCompressed(boolean compressed) {
        this.compressed = Optional.of((Object)compressed);
    }

    public String getTitle() {
        return (String)this.title.or((Object)MAPFISH_PRINT);
    }

    public void setTitle(String title) {
        this.title = Optional.of((Object)title);
    }

    public String getAuthor() {
        return (String)this.author.or((Object)MAPFISH_PRINT);
    }

    public void setAuthor(String author) {
        this.author = Optional.of((Object)author);
    }

    public String getSubject() {
        return (String)this.subject.or((Object)MAPFISH_PRINT);
    }

    public void setSubject(String subject) {
        this.subject = Optional.of((Object)subject);
    }

    public String getKeywordsAsString() {
        return (String)this.keywords.or((Object)MAPFISH_PRINT);
    }

    public void setKeywords(List<String> keywords) {
        StringBuilder builder = new StringBuilder();
        for (String keyword : keywords) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(keyword.trim());
        }
        this.keywords = Optional.of((Object)builder.toString());
    }

    public String getCreator() {
        return (String)this.creator.or((Object)MAPFISH_PRINT);
    }

    public void setCreator(String creator) {
        this.creator = Optional.of((Object)creator);
    }
}

