/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.WorkingDirectories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkingDirectories {
    private static final String TASK_DIR_PREFIX = "task-";
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkingDirectories.class);
    private File working;
    private File reports;
    private int maxAgeReport;
    private int maxAgeTaskDir;

    public final void setWorking(File working) {
        this.working = working;
    }

    public final File getWorking() {
        return this.working;
    }

    public final void setMaxAgeReport(int maxAgeReport) {
        this.maxAgeReport = maxAgeReport;
    }

    public final void setMaxAgeTaskDir(int maxAgeTaskDir) {
        this.maxAgeTaskDir = maxAgeTaskDir;
    }

    @PostConstruct
    public final void init() {
        this.reports = new File(this.working, "reports");
    }

    public final File getJasperCompilation(Configuration configuration) {
        File jasperCompilation = new File(this.getWorking(configuration), "jasper-bin");
        this.createIfMissing(jasperCompilation, "Jasper Compilation");
        return jasperCompilation;
    }

    public final File getReports() {
        this.createIfMissing(this.reports, "Reports");
        return this.reports;
    }

    public final File getTaskDirectory() {
        this.createIfMissing(this.working, "Working");
        try {
            File file = File.createTempFile(TASK_DIR_PREFIX, "tmp", this.working);
            if (!file.delete() || !file.mkdirs()) {
                throw new IOException("Unable to make temporary directory: " + file);
            }
            return file;
        }
        catch (IOException e) {
            throw new AssertionError((Object)("Unable to create temporary directory in '" + this.working + "'"));
        }
    }

    public final void removeDirectory(File directory) {
        try {
            FileUtils.deleteDirectory((File)directory);
        }
        catch (IOException e) {
            LOGGER.error("Unable to delete directory '" + directory + "'");
        }
    }

    private void createIfMissing(File directory, String name) {
        if (!(directory.exists() || directory.mkdirs() || directory.exists())) {
            throw new AssertionError((Object)("Unable to create working directory: '" + directory + "' it is the '" + name + "' directory"));
        }
    }

    public final File getBuildFileFor(Configuration configuration, File jasperFileXml, String extension, Logger logger) {
        String relativePathToFile;
        String configurationAbsolutePath = configuration.getDirectory().getPath();
        int prefixToConfiguration = configurationAbsolutePath.length() + 1;
        String parentDir = jasperFileXml.getAbsoluteFile().getParent();
        if (configurationAbsolutePath.equals(parentDir)) {
            relativePathToFile = Files.getNameWithoutExtension((String)jasperFileXml.getName());
        } else {
            String relativePathToContainingDirectory = parentDir.substring(prefixToConfiguration);
            relativePathToFile = relativePathToContainingDirectory + File.separator + Files.getNameWithoutExtension((String)jasperFileXml.getName());
        }
        File buildFile = new File(this.getJasperCompilation(configuration), relativePathToFile + extension);
        if (!buildFile.getParentFile().exists() && !buildFile.getParentFile().mkdirs()) {
            logger.error("Unable to create directory for containing compiled jasper report templates: " + buildFile.getParentFile());
        }
        return buildFile;
    }

    public final File getWorking(Configuration configuration) {
        return new File(this.working, configuration.getDirectory().getName());
    }

    public final Runnable getCleanUpTask() {
        return new CleanUpTask(this, (long)this.maxAgeReport, (long)this.maxAgeTaskDir);
    }

    static /* synthetic */ File access$000(WorkingDirectories x0) {
        return x0.reports;
    }

    static /* synthetic */ File access$100(WorkingDirectories x0) {
        return x0.working;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }
}

