/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.http;

import java.io.ByteArrayInputStream;
import java.net.URI;
import java.security.KeyStore;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationObject;
import org.mapfish.print.config.HasConfiguration;

public final class CertificateStore
implements ConfigurationObject,
HasConfiguration {
    private URI uri;
    private char[] password;
    private Configuration configuration;
    private volatile SSLContext sslContext;

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setPassword(String password) {
        this.password = password.toCharArray();
    }

    public void validate(List<Throwable> validationErrors, Configuration config) {
        if (this.uri == null) {
            validationErrors.add(new IllegalStateException("path is a required parameter"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContext getSSLContext() {
        if (this.sslContext == null) {
            CertificateStore certificateStore = this;
            synchronized (certificateStore) {
                if (this.sslContext == null) {
                    this.sslContext = this.createSslContext();
                }
            }
        }
        return this.sslContext;
    }

    private SSLContext createSslContext() {
        try {
            SSLContext newSslContext = SSLContext.getInstance("TLS");
            KeyStore ks = KeyStore.getInstance("JKS");
            byte[] bytes = this.configuration.loadFile(this.uri.toString());
            ks.load(new ByteArrayInputStream(bytes), this.password);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, this.password);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ks);
            newSslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            return newSslContext;
        }
        catch (Throwable t) {
            throw ExceptionUtils.getRuntimeException((Throwable)t);
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

