/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.http;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.annotation.Nonnull;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.ConfigFileResolvingHttpRequestFactory;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.http.MfClientHttpRequestFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;

public final class ConfigFileResolvingHttpRequestFactory
implements MfClientHttpRequestFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigFileResolvingHttpRequestFactory.class);
    private final Configuration config;
    private final MfClientHttpRequestFactoryImpl httpRequestFactory;
    private final List<MfClientHttpRequestFactory.RequestConfigurator> callbacks = Lists.newCopyOnWriteArrayList();

    public ConfigFileResolvingHttpRequestFactory(MfClientHttpRequestFactoryImpl httpRequestFactory, Configuration config) {
        this.httpRequestFactory = httpRequestFactory;
        this.config = config;
    }

    public void register(@Nonnull MfClientHttpRequestFactory.RequestConfigurator callback) {
        this.callbacks.add(callback);
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        return new ConfigFileResolvingRequest(this, uri, httpMethod);
    }

    static /* synthetic */ MfClientHttpRequestFactoryImpl access$000(ConfigFileResolvingHttpRequestFactory x0) {
        return x0.httpRequestFactory;
    }

    static /* synthetic */ Configuration access$100(ConfigFileResolvingHttpRequestFactory x0) {
        return x0.config;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }

    static /* synthetic */ List access$300(ConfigFileResolvingHttpRequestFactory x0) {
        return x0.callbacks;
    }
}

