/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.measure.unit.Unit;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * Exception performing whole class analysis ignored.
 */
public enum DistanceUnit {
    M(null, 1.0, 1.0, new String[]{"m", "meter", "meters"}),
    MM(M, 0.001, 0.001, new String[]{"mm", "millimeter", "millimeters"}),
    CM(M, 0.01, 0.01, new String[]{"cm", "centimeter", "centimeters"}),
    KM(M, 1000.0, 1000.0, new String[]{"km", "kilometer", "kilometers"}),
    FT(null, 1.0, 0.30479999999999996, new String[]{"ft", "foot", "feet"}),
    IN(FT, 0.08333333333333333, 0.0254, new String[]{"in", "inch"}),
    YD(FT, 3.0, 0.9143999999999999, new String[]{"yd", "yard", "yards"}),
    MI(FT, 5280.0, 1609.3439999999998, new String[]{"mi", "mile", "miles"}),
    DEGREES(null, 1.0, 111226.30555555556, new String[]{"\u00b0", "dd", "degree", "degrees"}),
    MINUTE(DEGREES, 0.016666666666666666, 111226.30555555556, new String[]{"min", "minute", "minutes"}),
    SECOND(DEGREES, 2.777777777777778E-4, 111226.30555555556, new String[]{"sec", "second", "seconds"}),
    PX(null, 1.0, 3.5277777777777776E-4, new String[]{"px", "pixel"});

    private final DistanceUnit baseUnit;
    private final double baseFactor;
    private final double metersFactor;
    private final String[] texts;
    private DistanceUnit[] allUnits = null;
    private static Map<String, DistanceUnit> translations;

    private DistanceUnit(DistanceUnit baseUnit, double baseFactor, double metersFactor, String[] texts) {
        this.baseUnit = baseUnit == null ? this : baseUnit;
        this.baseFactor = baseFactor;
        this.texts = texts;
        this.metersFactor = metersFactor;
    }

    public boolean isBase() {
        return this.baseUnit == this;
    }

    public double convertTo(double value, DistanceUnit targetUnit) {
        if (targetUnit == this) {
            return value;
        }
        if (this.isSameBaseUnit(targetUnit)) {
            return value * this.baseFactor / targetUnit.baseFactor;
        }
        return value * this.metersFactor / targetUnit.metersFactor;
    }

    public boolean isSameBaseUnit(DistanceUnit target) {
        return target.baseUnit == this.baseUnit || target == this.baseUnit || target.baseUnit == this;
    }

    public final String toString() {
        return this.texts[0];
    }

    public static DistanceUnit fromString(String val) {
        return (DistanceUnit)DistanceUnit.getTranslations().get(val.toLowerCase());
    }

    public final synchronized DistanceUnit[] getAllUnits() {
        if (this.allUnits == null) {
            if (this.baseUnit != this) {
                this.allUnits = this.baseUnit.getAllUnits();
            } else {
                DistanceUnit[] values = DistanceUnit.values();
                ArrayList<DistanceUnit> list = new ArrayList<DistanceUnit>(values.length);
                for (int i = 0; i < values.length; ++i) {
                    DistanceUnit value = values[i];
                    if (value.baseUnit != this) continue;
                    list.add(value);
                }
                DistanceUnit[] result = new DistanceUnit[list.size()];
                list.toArray(result);
                Arrays.sort(result, new /* Unavailable Anonymous Inner Class!! */);
                this.allUnits = result;
            }
        }
        return this.allUnits;
    }

    public static DistanceUnit getBestUnit(double value, DistanceUnit unit) {
        DistanceUnit[] units = unit.getAllUnits();
        for (int i = units.length - 1; i >= 0; --i) {
            DistanceUnit cur = units[i];
            double converted = Math.abs(unit.convertTo(1.0, cur) * value);
            if (!(converted >= 1.0)) continue;
            return cur;
        }
        return units[0];
    }

    private static synchronized Map<String, DistanceUnit> getTranslations() {
        if (translations == null) {
            DistanceUnit[] values;
            translations = new HashMap();
            for (DistanceUnit cur : values = DistanceUnit.values()) {
                for (int j = 0; j < cur.texts.length; ++j) {
                    translations.put(cur.texts[j], cur);
                }
            }
        }
        return translations;
    }

    public static DistanceUnit fromProjection(CoordinateReferenceSystem projection) {
        Unit projectionUnit = projection.getCoordinateSystem().getAxis(0).getUnit();
        return DistanceUnit.fromString((String)projectionUnit.toString());
    }

    static /* synthetic */ double access$000(DistanceUnit x0) {
        return x0.baseFactor;
    }

    static {
        translations = null;
    }
}

