/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.vividsolutions.jts.util.Assert;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.FloatingPointUtil;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.AbstractLayerParams;
import org.mapfish.print.map.geotools.OpacitySettingStyleVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGeotoolsLayer
implements MapLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGeotoolsLayer.class);
    private final ExecutorService executorService;
    private final AbstractLayerParams params;

    protected AbstractGeotoolsLayer(ExecutorService executorService, AbstractLayerParams params) {
        this.executorService = executorService;
        this.params = params;
    }

    public final Optional<MapLayer> tryAddLayer(MapLayer newLayer) {
        return Optional.absent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void render(Graphics2D graphics2D, MfClientHttpRequestFactory clientHttpRequestFactory, MapfishMapContext transformer, boolean isFirstLayer) {
        block8: {
            Rectangle paintArea = new Rectangle(transformer.getMapSize());
            MapBounds bounds = transformer.getBounds();
            MapfishMapContext layerTransformer = transformer;
            if (!FloatingPointUtil.equals((double)transformer.getRotation(), (double)0.0) && !this.supportsNativeRotation()) {
                paintArea = new Rectangle(transformer.getRotatedMapSize());
                bounds = transformer.getRotatedBounds();
                graphics2D.setTransform(transformer.getTransform());
                Dimension mapSize = new Dimension(paintArea.width, paintArea.height);
                layerTransformer = new MapfishMapContext(transformer, bounds, mapSize, transformer.getRotation(), transformer.getDPI(), transformer.getRequestorDPI(), transformer.isForceLongitudeFirst(), transformer.isDpiSensitiveStyle().booleanValue());
            }
            MapContent content = new MapContent();
            try {
                List layers = this.getLayers(clientHttpRequestFactory, layerTransformer, isFirstLayer);
                this.applyTransparency(layers);
                content.addLayers((Collection)layers);
                StreamingRenderer renderer = new StreamingRenderer();
                RenderingHints hints = new RenderingHints(Collections.emptyMap());
                hints.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY));
                hints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
                hints.add(new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY));
                hints.add(new RenderingHints(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE));
                hints.add(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON));
                hints.add(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC));
                hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
                hints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
                hints.add(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
                graphics2D.addRenderingHints(hints);
                renderer.setJava2DHints(hints);
                HashMap renderHints = Maps.newHashMap();
                if (transformer.isForceLongitudeFirst() != null) {
                    renderHints.put("ForceEPSGAxisOrder", transformer.isForceLongitudeFirst());
                }
                renderer.setRendererHints((Map)renderHints);
                renderer.setMapContent(content);
                renderer.setThreadPool(this.executorService);
                ReferencedEnvelope mapArea = bounds.toReferencedEnvelope(paintArea, transformer.getDPI());
                renderer.paint(graphics2D, paintArea, mapArea);
            }
            catch (Exception e) {
                if (e instanceof NullPointerException || e.getCause() instanceof NullPointerException) {
                    LOGGER.info("Rendering layer failed", (Throwable)e);
                    break block8;
                }
                throw ExceptionUtils.getRuntimeException((Throwable)e);
            }
            finally {
                content.dispose();
            }
        }
    }

    private void applyTransparency(List<? extends Layer> layers) {
        double opacity = this.params.opacity;
        Assert.isTrue((opacity > -0.001 && opacity < 1.001 ? 1 : 0) != 0, (String)("Opacity of " + this + " is an illegal value: " + opacity));
        if (1.0 - opacity > 0.001) {
            OpacitySettingStyleVisitor visitor = new OpacitySettingStyleVisitor(opacity);
            for (Layer layer : layers) {
                Style style = layer.getStyle();
                style.accept((StyleVisitor)visitor);
            }
        }
    }

    protected abstract List<? extends Layer> getLayers(MfClientHttpRequestFactory var1, MapfishMapContext var2, boolean var3) throws Exception;

    public boolean supportsNativeRotation() {
        return false;
    }

    public final String getName() {
        return this.params.name;
    }

    public final boolean getFailOnError() {
        return this.params.failOnError;
    }
}

