/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharSource;
import com.google.common.io.CharStreams;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import com.vividsolutions.jts.geom.Geometry;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.Constants;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.FileUtils;
import org.mapfish.print.PrintException;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class FeaturesParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesParser.class);
    private final MfClientHttpRequestFactory httpRequestFactory;
    private final boolean forceLongitudeFirst;

    public FeaturesParser(MfClientHttpRequestFactory httpRequestFactory, boolean forceLongitudeFirst) {
        this.httpRequestFactory = httpRequestFactory;
        this.forceLongitudeFirst = forceLongitudeFirst;
    }

    public final SimpleFeatureCollection autoTreat(Template template, String features) throws IOException {
        SimpleFeatureCollection featuresCollection = this.treatStringAsURL(template, features);
        if (featuresCollection == null) {
            featuresCollection = this.treatStringAsGeoJson(features);
        }
        return featuresCollection;
    }

    public final SimpleFeatureCollection treatStringAsURL(Template template, String geoJsonUrl) throws IOException {
        String geojsonString;
        URL url;
        try {
            url = FileUtils.testForLegalFileUrl((Configuration)template.getConfiguration(), (URL)new URL(geoJsonUrl));
        }
        catch (MalformedURLException e) {
            return null;
        }
        Closer closer = Closer.create();
        try {
            Reader input;
            if (url.getProtocol().equalsIgnoreCase("file")) {
                CharSource charSource = Files.asCharSource((File)new File(url.getFile()), (Charset)Constants.DEFAULT_CHARSET);
                input = (Reader)closer.register((Closeable)charSource.openBufferedStream());
            } else {
                ClientHttpResponse response = (ClientHttpResponse)closer.register((Closeable)this.httpRequestFactory.createRequest(url.toURI(), HttpMethod.GET).execute());
                input = (Reader)closer.register((Closeable)new BufferedReader(new InputStreamReader(response.getBody(), Constants.DEFAULT_CHARSET)));
            }
            geojsonString = CharStreams.toString((Readable)input);
        }
        catch (URISyntaxException e) {
            throw ExceptionUtils.getRuntimeException((Throwable)e);
        }
        finally {
            closer.close();
        }
        return this.treatStringAsGeoJson(geojsonString);
    }

    public final SimpleFeatureCollection treatStringAsGeoJson(String geoJsonString) throws IOException {
        return this.readFeatureCollection(geoJsonString);
    }

    private SimpleFeatureCollection readFeatureCollection(String geojsonData) throws IOException {
        String convertedGeojsonObject = this.convertToGeoJsonCollection(geojsonData);
        FeatureJSON geoJsonReader = new FeatureJSON();
        SimpleFeatureType featureType = this.createFeatureType(convertedGeojsonObject);
        if (featureType != null) {
            geoJsonReader.setFeatureType(featureType);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(convertedGeojsonObject.getBytes(Constants.DEFAULT_CHARSET));
        return (SimpleFeatureCollection)geoJsonReader.readFeatureCollection((InputStream)input);
    }

    private String convertToGeoJsonCollection(String geojsonData) {
        String convertedGeojsonObject = geojsonData.trim();
        if (convertedGeojsonObject.startsWith("[")) {
            convertedGeojsonObject = "{\"type\": \"FeatureCollection\", \"features\": " + convertedGeojsonObject + "}";
        }
        return convertedGeojsonObject;
    }

    private SimpleFeatureType createFeatureType(@Nonnull String geojsonData) {
        try {
            JSONObject geojson = new JSONObject(geojsonData);
            if (geojson.has("type") && geojson.getString("type").equalsIgnoreCase("FeatureCollection")) {
                CoordinateReferenceSystem crs = FeaturesParser.parseCoordinateReferenceSystem((MfClientHttpRequestFactory)this.httpRequestFactory, (JSONObject)geojson, (boolean)this.forceLongitudeFirst);
                SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
                builder.setName("GeosjonFeatureType");
                JSONArray features = geojson.getJSONArray("features");
                if (features.length() == 0) {
                    return null;
                }
                HashSet allAttributes = Sets.newHashSet();
                Class<Geometry> geomType = null;
                for (int i = 0; i < features.length(); ++i) {
                    JSONObject feature = features.getJSONObject(i);
                    JSONObject properties = feature.getJSONObject("properties");
                    Iterator keys = properties.keys();
                    while (keys.hasNext()) {
                        Class<Geometry> thisGeomType;
                        String nextKey = (String)keys.next();
                        if (!allAttributes.contains(nextKey)) {
                            allAttributes.add(nextKey);
                            builder.add(nextKey, Object.class);
                        }
                        if (geomType == Geometry.class || (thisGeomType = this.parseGeometryType(feature)) == null) continue;
                        if (geomType == null) {
                            geomType = thisGeomType;
                            continue;
                        }
                        if (geomType == thisGeomType) continue;
                        geomType = Geometry.class;
                    }
                }
                builder.add("geometry", geomType, crs);
                builder.setDefaultGeometry("geometry");
                return builder.buildFeatureType();
            }
            return null;
        }
        catch (JSONException e) {
            throw new PrintException("Invalid geoJSON: \n" + geojsonData + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private Class<Geometry> parseGeometryType(@Nonnull JSONObject featureJson) throws JSONException {
        JSONObject geomJson = featureJson.optJSONObject("geometry");
        if (geomJson == null) {
            return null;
        }
        String geomTypeString = geomJson.optString("type", "Geometry");
        if (geomTypeString.equalsIgnoreCase("Positions")) {
            return Geometry.class;
        }
        try {
            return Class.forName("com.vividsolutions.jts.geom." + geomTypeString);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unrecognized geometry type in geojson: " + geomTypeString);
        }
    }

    @VisibleForTesting
    static final CoordinateReferenceSystem parseCoordinateReferenceSystem(MfClientHttpRequestFactory requestFactory, JSONObject geojson, boolean forceLongitudeFirst) {
        DefaultEngineeringCRS crs = DefaultEngineeringCRS.GENERIC_2D;
        StringBuilder code = new StringBuilder();
        try {
            if (geojson.has("crs")) {
                JSONObject crsJson = geojson.getJSONObject("crs");
                String type = crsJson.optString("type", "");
                if (type.equalsIgnoreCase("EPSG") || type.equalsIgnoreCase("CRS")) {
                    code.append(type);
                    String propCode = FeaturesParser.getProperty((JSONObject)crsJson, (String)"code");
                    if (propCode != null) {
                        code.append(":").append(propCode);
                    }
                } else if (type.equalsIgnoreCase("name")) {
                    String propCode = FeaturesParser.getProperty((JSONObject)crsJson, (String)"name");
                    if (propCode != null) {
                        code.append(propCode);
                    }
                } else if (type.equals("link")) {
                    String linkType = FeaturesParser.getProperty((JSONObject)crsJson, (String)"type");
                    if (linkType != null && (linkType.equalsIgnoreCase("esriwkt") || linkType.equalsIgnoreCase("ogcwkt"))) {
                        ClientHttpRequest request;
                        ClientHttpResponse response;
                        String uri = FeaturesParser.getProperty((JSONObject)crsJson, (String)"href");
                        if (uri != null && (response = (request = requestFactory.createRequest(new URI(uri), HttpMethod.GET)).execute()).getStatusCode() == HttpStatus.OK) {
                            String wkt = new String(ByteStreams.toByteArray((InputStream)response.getBody()), Constants.DEFAULT_ENCODING);
                            try {
                                return CRS.parseWKT((String)wkt);
                            }
                            catch (FactoryException e) {
                                LOGGER.warn("Unable to load linked CRS from geojson: \n" + crsJson + "\n\nWKT loaded from:\n" + wkt);
                            }
                        }
                    } else {
                        LOGGER.warn("Unable to load linked CRS from geojson: \n" + crsJson);
                    }
                } else {
                    code.append(FeaturesParser.getProperty((JSONObject)crsJson, (String)"code"));
                }
            }
        }
        catch (JSONException e) {
            LOGGER.warn("Error reading the required elements to parse crs of the geojson: \n" + geojson, (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOGGER.warn("Error reading the required elements to parse crs of the geojson: \n" + geojson, (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.warn("Error reading the required elements to parse crs of the geojson: \n" + geojson, (Throwable)e);
        }
        try {
            if (code.length() > 0) {
                crs = CRS.decode((String)code.toString(), (boolean)forceLongitudeFirst);
            }
        }
        catch (NoSuchAuthorityCodeException e) {
            LOGGER.warn("No CRS with code: " + code + ".\nRead from geojson: \n" + geojson);
        }
        catch (FactoryException e) {
            LOGGER.warn("Error loading CRS with code: " + code + ".\nRead from geojson: \n" + geojson);
        }
        return crs;
    }

    private static String getProperty(JSONObject crsJson, String nameCode) throws JSONException {
        JSONObject propertiesJson;
        if (crsJson.has("properties") && (propertiesJson = crsJson.getJSONObject("properties")).has(nameCode)) {
            return propertiesJson.getString(nameCode);
        }
        return null;
    }
}

