/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.Layer;
import org.geotools.styling.Style;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.AbstractLayerParams;
import org.mapfish.print.map.geotools.AbstractGeotoolsLayer;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.opengis.geometry.Envelope;

public abstract class AbstractSingleImageLayer
extends AbstractGeotoolsLayer {
    private final StyleSupplier<GridCoverage2D> styleSupplier;

    protected AbstractSingleImageLayer(ExecutorService executorService, StyleSupplier<GridCoverage2D> styleSupplier, AbstractLayerParams params) {
        super(executorService, params);
        this.styleSupplier = styleSupplier;
    }

    protected final List<? extends Layer> getLayers(MfClientHttpRequestFactory httpRequestFactory, MapfishMapContext mapContext, boolean isFirstLayer) throws Exception {
        BufferedImage image;
        try {
            image = this.loadImage(httpRequestFactory, mapContext, isFirstLayer);
        }
        catch (Throwable t) {
            throw ExceptionUtils.getRuntimeException((Throwable)t);
        }
        MapBounds bounds = mapContext.getBounds();
        ReferencedEnvelope mapEnvelope = bounds.toReferencedEnvelope(mapContext.getPaintArea(), mapContext.getDPI());
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
        GeneralEnvelope gridEnvelope = new GeneralEnvelope(mapEnvelope.getCoordinateReferenceSystem());
        gridEnvelope.setEnvelope(new double[]{mapEnvelope.getMinX(), mapEnvelope.getMinY(), mapEnvelope.getMaxX(), mapEnvelope.getMaxY()});
        String coverageName = this.getClass().getSimpleName();
        GridCoverage2D gridCoverage2D = factory.create((CharSequence)coverageName, (RenderedImage)image, (Envelope)gridEnvelope, null, null, null);
        Style style = this.styleSupplier.load(httpRequestFactory, (Object)gridCoverage2D, mapContext);
        return Collections.singletonList(new GridCoverageLayer(gridCoverage2D, style));
    }

    protected abstract BufferedImage loadImage(MfClientHttpRequestFactory var1, MapfishMapContext var2, boolean var3) throws Throwable;
}

