/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.image.wms;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.geotools.data.wms.request.GetMapRequest;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.mapfish.print.URIUtils;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.image.wms.WmsLayerParam;
import org.mapfish.print.map.image.wms.WmsUtilities;
import org.mapfish.print.map.image.wms.WmsVersion;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;

/*
 * Exception performing whole class analysis ignored.
 */
public final class WmsUtilities {
    private WmsUtilities() {
    }

    public static URI makeWmsGetLayerRequest(MfClientHttpRequestFactory requestFactory, WmsLayerParam wmsLayerParam, URI commonURI, Dimension imageSize, double dpi, ReferencedEnvelope bounds) throws FactoryException, URISyntaxException, IOException {
        GetMapRequest getMapRequest = WmsVersion.lookup((String)wmsLayerParam.version).getGetMapRequest(commonURI.toURL());
        getMapRequest.setBBox((Envelope)bounds);
        getMapRequest.setDimensions(imageSize.width, imageSize.height);
        getMapRequest.setFormat(wmsLayerParam.imageFormat);
        getMapRequest.setSRS(CRS.lookupIdentifier((IdentifiedObject)bounds.getCoordinateReferenceSystem(), (boolean)false));
        for (int i = wmsLayerParam.layers.length - 1; i > -1; --i) {
            String layer = wmsLayerParam.layers[i];
            String style = "";
            if (wmsLayerParam.styles != null) {
                style = wmsLayerParam.styles[i];
            }
            getMapRequest.addLayer(layer, style);
        }
        URI getMapUri = getMapRequest.getFinalURL().toURI();
        HashMultimap extraParams = HashMultimap.create();
        extraParams.putAll(wmsLayerParam.getMergeableParams());
        extraParams.putAll(wmsLayerParam.getCustomParams());
        if (wmsLayerParam.serverType != null && dpi != 72.0) {
            WmsUtilities.addDpiParam((Multimap)extraParams, (int)((int)Math.round(dpi)), (WmsLayerParam.ServerType)wmsLayerParam.serverType);
        }
        return URIUtils.addParams((URI)getMapUri, (Multimap)extraParams, Collections.emptySet());
    }

    private static void addDpiParam(Multimap<String, String> extraParams, int dpi, WmsLayerParam.ServerType type) {
        switch (1.$SwitchMap$org$mapfish$print$map$image$wms$WmsLayerParam$ServerType[type.ordinal()]) {
            case 1: {
                if (WmsUtilities.contains(extraParams, (String)"MAP_RESOLUTION")) break;
                extraParams.put((Object)"MAP_RESOLUTION", (Object)Integer.toString(dpi));
                break;
            }
            case 2: {
                if (WmsUtilities.contains(extraParams, (String)"DPI")) break;
                extraParams.put((Object)"DPI", (Object)Integer.toString(dpi));
                break;
            }
            case 3: {
                if (!WmsUtilities.contains(extraParams, (String)"FORMAT_OPTIONS")) {
                    extraParams.put((Object)"FORMAT_OPTIONS", (Object)("dpi:" + Integer.toString(dpi)));
                    break;
                }
                if (WmsUtilities.isDpiSet(extraParams)) break;
                WmsUtilities.setDpiValue(extraParams, (int)dpi);
                break;
            }
        }
    }

    private static boolean contains(Multimap<String, ?> map, String searchKey) {
        for (String key : map.keys()) {
            if (!key.equalsIgnoreCase(searchKey)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDpiSet(Multimap<String, String> extraParams) {
        String searchKey = "FORMAT_OPTIONS";
        for (String key : extraParams.keys()) {
            if (!key.equalsIgnoreCase(searchKey)) continue;
            for (String value : extraParams.get((Object)key)) {
                if (!value.toLowerCase().contains("dpi:")) continue;
                return true;
            }
        }
        return false;
    }

    private static void setDpiValue(Multimap<String, String> extraParams, int dpi) {
        String searchKey = "FORMAT_OPTIONS";
        for (String key : extraParams.keys()) {
            if (!key.equalsIgnoreCase(searchKey)) continue;
            Collection values = extraParams.removeAll((Object)key);
            ArrayList<String> newValues = new ArrayList<String>();
            for (String value : values) {
                if (Strings.isNullOrEmpty((String)value)) continue;
                value = value + ";dpi:" + Integer.toString(dpi);
                newValues.add(value);
            }
            extraParams.putAll((Object)key, newValues);
        }
    }
}

