/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.style;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.common.io.Closeables;
import com.vividsolutions.jts.util.Assert;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.mapfish.print.Constants;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.map.style.ParserPluginUtils;
import org.mapfish.print.map.style.SLDParserPlugin;
import org.mapfish.print.map.style.StyleParserPlugin;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.xml.sax.InputSource;

public class SLDParserPlugin
implements StyleParserPlugin {
    public static final String STYLE_INDEX_REF_SEPARATOR = "##";

    public final Optional<Style> parseStyle(@Nullable Configuration configuration, @Nonnull ClientHttpRequestFactory clientHttpRequestFactory, @Nonnull String styleString, @Nonnull MapfishMapContext mapContext) throws Throwable {
        ByteSource straightByteSource = ByteSource.wrap((byte[])styleString.getBytes(Constants.DEFAULT_CHARSET));
        Optional styleOptional = this.tryLoadSLD(straightByteSource, null);
        if (styleOptional.isPresent()) {
            return styleOptional;
        }
        Integer styleIndex = (Integer)this.lookupStyleIndex(styleString).orNull();
        String styleStringWithoutIndexReference = this.removeIndexReference(styleString);
        1 loadFunction = new /* Unavailable Anonymous Inner Class!! */;
        return ParserPluginUtils.loadStyleAsURI((ClientHttpRequestFactory)clientHttpRequestFactory, (String)styleStringWithoutIndexReference, (Function)loadFunction);
    }

    private String removeIndexReference(String styleString) {
        int styleIdentifier = styleString.lastIndexOf(STYLE_INDEX_REF_SEPARATOR);
        if (styleIdentifier > 0) {
            return styleString.substring(0, styleIdentifier);
        }
        return styleString;
    }

    private Optional<Integer> lookupStyleIndex(String ref) {
        int styleIdentifier = ref.lastIndexOf(STYLE_INDEX_REF_SEPARATOR);
        if (styleIdentifier > 0) {
            return Optional.of((Object)(Integer.parseInt(ref.substring(styleIdentifier + 2)) - 1));
        }
        return Optional.absent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Style> tryLoadSLD(ByteSource byteSource, Integer styleIndex) throws IOException {
        Style[] styles;
        Assert.isTrue((styleIndex == null || styleIndex > -1 ? 1 : 0) != 0, (String)("styleIndex must be > -1 but was: " + styleIndex));
        CharSource charSource = byteSource.asCharSource(Constants.DEFAULT_CHARSET);
        BufferedReader readerXML = null;
        BufferedReader readerSLD = null;
        try {
            readerXML = charSource.openBufferedStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler((org.xml.sax.ErrorHandler)new ErrorHandler());
            db.parse(new InputSource(readerXML));
            readerSLD = charSource.openBufferedStream();
            SLDParser sldParser = new SLDParser(CommonFactoryFinder.getStyleFactory());
            sldParser.setInput((Reader)readerSLD);
            styles = sldParser.readXML();
        }
        catch (Throwable e) {
            try {
                Optional optional = Optional.absent();
                return optional;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                Closeables.close((Closeable)readerXML, (boolean)true);
                Closeables.close(readerSLD, (boolean)true);
            }
        }
        Closeables.close((Closeable)readerXML, (boolean)true);
        Closeables.close((Closeable)readerSLD, (boolean)true);
        if (styleIndex != null) {
            Assert.isTrue((styleIndex < styles.length ? 1 : 0) != 0, (String)("There where " + styles.length + " styles in file but requested index was: " + (styleIndex + 1)));
        } else {
            Assert.isTrue((styles.length < 2 ? 1 : 0) != 0, (String)("There are " + styles.length + " therefore the styleRef must contain an index " + "identifying the style.  The index starts at 1 for the first style." + "\n\tExample: thinline.sld##1"));
        }
        if (styleIndex == null) {
            return Optional.of((Object)styles[0]);
        }
        return Optional.of((Object)styles[styleIndex]);
    }

    static /* synthetic */ Optional access$000(SLDParserPlugin x0, ByteSource x1, Integer x2) throws IOException {
        return x0.tryLoadSLD(x1, x2);
    }
}

