/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.style.json;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.map.style.json.JsonStyleParserHelper;
import org.mapfish.print.map.style.json.MapfishJsonStyleParserPlugin;
import org.mapfish.print.map.style.json.MapfishJsonStyleVersion2;
import org.mapfish.print.wrapper.json.PJsonArray;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.IncludeFilter;

/*
 * Exception performing whole class analysis ignored.
 */
public final class MapfishJsonStyleVersion2 {
    static final String JSON_SYMB = "symbolizers";
    private static final String JSON_TYPE = "type";
    private static final Pattern VALUE_EXPR_PATTERN = Pattern.compile("\\$\\{([\\w\\d_-]+)\\}");
    private static final String JSON_MIN_SCALE = "minScale";
    private static final String JSON_MAX_SCALE = "maxScale";
    private static final String JSON_FILTER_INCLUDE = "*";
    private final PJsonObject json;
    private final StyleBuilder styleBuilder;
    private final JsonStyleParserHelper parserHelper;

    MapfishJsonStyleVersion2(@Nonnull PJsonObject json, @Nonnull StyleBuilder styleBuilder, @Nonnull Configuration configuration) {
        this.json = json;
        this.styleBuilder = styleBuilder;
        this.parserHelper = new JsonStyleParserHelper(configuration, styleBuilder, false, MapfishJsonStyleParserPlugin.Versions.TWO);
    }

    Style parseStyle() {
        ArrayList rules = Lists.newArrayList();
        Iterator keys = this.json.keys();
        while (keys.hasNext()) {
            String next = ((String)keys.next()).trim();
            if (!this.isRule(next)) continue;
            rules.add(this.createRule(next));
        }
        if (rules.isEmpty()) {
            throw new IllegalArgumentException("No rules found in style.  Rules are json objects that have the key * or have the form: [ecql]");
        }
        return this.parserHelper.createStyle((List)rules);
    }

    private Rule createRule(String jsonKey) {
        PJsonObject ruleJson = this.json.getJSONObject(jsonKey);
        IncludeFilter filter = Filter.INCLUDE;
        if (!jsonKey.equals("*")) {
            try {
                filter = ECQL.toFilter((String)jsonKey, (FilterFactory)this.styleBuilder.getFilterFactory());
            }
            catch (CQLException e) {
                throw new RuntimeException("Error compiling rule filter: " + jsonKey, e);
            }
        }
        PJsonArray symbolizerJsonArray = ruleJson.getJSONArray("symbolizers");
        Symbolizer[] symbolizers = new Symbolizer[symbolizerJsonArray.size()];
        for (int i = 0; i < symbolizerJsonArray.size(); ++i) {
            PJsonObject symbolizerJson = symbolizerJsonArray.getJSONObject(i);
            this.updateSymbolizerProperties(ruleJson, symbolizerJson);
            SymbolizerType type = SymbolizerType.valueOf((String)symbolizerJson.getString("type").toUpperCase());
            symbolizers[i] = type.parseJson(this.parserHelper, symbolizerJson);
            if (symbolizers[i] != null) continue;
            throw new RuntimeException("Error creating symbolizer " + symbolizerJson.getString("type") + " in rule " + jsonKey);
        }
        Map ruleValues = this.buildValuesMap(ruleJson, new PJsonObject(new JSONObject(), "empty"));
        double minScale = this.getScaleDenominator(ruleValues, "minScale", Double.MIN_VALUE);
        double maxScale = this.getScaleDenominator(ruleValues, "maxScale", Double.MAX_VALUE);
        Rule rule = this.styleBuilder.createRule(symbolizers, minScale, maxScale);
        rule.setFilter((Filter)filter);
        return rule;
    }

    private void updateSymbolizerProperties(PJsonObject ruleJson, PJsonObject symbolizerJson) {
        Map values = this.buildValuesMap(ruleJson, symbolizerJson);
        for (Map.Entry entry : values.entrySet()) {
            try {
                symbolizerJson.getInternalObj().put((String)entry.getKey(), entry.getValue());
            }
            catch (JSONException e) {
                throw ExceptionUtils.getRuntimeException((Throwable)e);
            }
        }
    }

    private double getScaleDenominator(Map<String, String> ruleValues, String keyName, double defaultValue) {
        String scaleString = ruleValues.get(keyName);
        if (scaleString != null) {
            return Double.parseDouble(scaleString);
        }
        return defaultValue;
    }

    private Map<String, String> buildValuesMap(PJsonObject ruleJson, PJsonObject symbolizerJson) {
        String key;
        HashMap values = Maps.newHashMap();
        Iterator keys = this.json.keys();
        while (keys.hasNext()) {
            key = ((String)keys.next()).trim();
            if (this.isRule(key)) continue;
            values.put(key, this.json.getString(key));
        }
        keys = ruleJson.keys();
        while (keys.hasNext()) {
            key = ((String)keys.next()).trim();
            if (key.equals("symbolizers")) continue;
            values.put(key, ruleJson.getString(key));
        }
        keys = symbolizerJson.keys();
        while (keys.hasNext()) {
            key = ((String)keys.next()).trim();
            if (key.equals("symbolizers")) continue;
            values.put(key, symbolizerJson.getString(key));
        }
        return MapfishJsonStyleVersion2.resolveAllValues((Map)values);
    }

    @VisibleForTesting
    static Map<String, String> resolveAllValues(Map<String, String> values) {
        HashMap toResolve = Maps.newHashMap(values);
        HashMap resolved = Maps.newHashMapWithExpectedSize((int)values.size());
        while (!toResolve.isEmpty()) {
            Iterator entries = toResolve.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry next = entries.next();
                String value = (String)next.getValue();
                String resolve = MapfishJsonStyleVersion2.resolve(values, (String)value);
                if (resolve == null) {
                    resolved.put(next.getKey(), value);
                    entries.remove();
                    continue;
                }
                next.setValue(resolve);
            }
        }
        return resolved;
    }

    private static String resolve(Map<String, String> values, String value) {
        int lastEnd = 0;
        Matcher matcher = VALUE_EXPR_PATTERN.matcher(value);
        boolean changed = false;
        StringBuilder updatedValue = new StringBuilder();
        while (matcher.find()) {
            String replacement;
            String valName = matcher.group(1);
            if (values.containsKey(valName)) {
                changed = true;
                replacement = values.get(valName);
            } else {
                replacement = matcher.group(0);
            }
            updatedValue.append(value.substring(lastEnd, matcher.start()));
            updatedValue.append(replacement);
            lastEnd = matcher.end();
        }
        if (changed) {
            updatedValue.append(value.substring(lastEnd));
            return updatedValue.toString();
        }
        return null;
    }

    private boolean isRule(String jsonKey) {
        return this.json.optJSONObject(jsonKey) != null;
    }
}

