/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled;

import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import jsr166y.ForkJoinPool;
import jsr166y.ForkJoinTask;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.Layer;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.AbstractLayerParams;
import org.mapfish.print.map.geotools.AbstractGeotoolsLayer;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.tiled.TileCacheInformation;
import org.mapfish.print.map.tiled.TileLoaderTask;

public abstract class AbstractTiledLayer
extends AbstractGeotoolsLayer {
    private final StyleSupplier<GridCoverage2D> styleSupplier;
    private final ForkJoinPool forkJoinPool;

    protected AbstractTiledLayer(ForkJoinPool forkJoinPool, StyleSupplier<GridCoverage2D> styleSupplier, AbstractLayerParams params) {
        super((ExecutorService)forkJoinPool, params);
        this.forkJoinPool = forkJoinPool;
        this.styleSupplier = styleSupplier;
    }

    protected final List<? extends Layer> getLayers(MfClientHttpRequestFactory httpRequestFactory, MapfishMapContext mapContext, boolean isFirstLayer) throws Exception {
        double dpi = mapContext.getDPI();
        MapBounds bounds = mapContext.getBounds();
        Rectangle paintArea = new Rectangle(mapContext.getMapSize());
        TileCacheInformation tileCacheInformation = this.createTileInformation(bounds, paintArea, dpi, isFirstLayer);
        TileLoaderTask task = new TileLoaderTask(httpRequestFactory, dpi, mapContext, tileCacheInformation, this.getFailOnError());
        GridCoverage2D gridCoverage2D = (GridCoverage2D)this.forkJoinPool.invoke((ForkJoinTask)task);
        GridCoverageLayer layer = new GridCoverageLayer(gridCoverage2D, this.styleSupplier.load(httpRequestFactory, (Object)gridCoverage2D, mapContext));
        return Collections.singletonList(layer);
    }

    protected abstract TileCacheInformation createTileInformation(MapBounds var1, Rectangle var2, double var3, boolean var5);
}

