/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import jsr166y.RecursiveTask;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.FloatingPointUtil;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.tiled.TileCacheInformation;
import org.mapfish.print.map.tiled.TileLoaderTask;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequest;

/*
 * Exception performing whole class analysis ignored.
 */
public final class TileLoaderTask
extends RecursiveTask<GridCoverage2D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TileLoaderTask.class);
    private final MapBounds bounds;
    private final Rectangle paintArea;
    private final double dpi;
    private final MapfishMapContext transformer;
    private final TileCacheInformation tiledLayer;
    private final BufferedImage errorImage;
    private final MfClientHttpRequestFactory httpRequestFactory;
    private final boolean failOnError;
    private Optional<Geometry> cachedRotatedMapBounds = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TileLoaderTask(MfClientHttpRequestFactory httpRequestFactory, double dpi, MapfishMapContext transformer, TileCacheInformation tileCacheInfo, boolean failOnError) {
        this.bounds = transformer.getBounds();
        this.paintArea = new Rectangle(transformer.getMapSize());
        this.dpi = dpi;
        this.httpRequestFactory = httpRequestFactory;
        this.transformer = transformer;
        this.tiledLayer = tileCacheInfo;
        this.failOnError = failOnError;
        Dimension tileSize = this.tiledLayer.getTileSize();
        this.errorImage = new BufferedImage(tileSize.width, tileSize.height, 6);
        Graphics2D graphics = this.errorImage.createGraphics();
        try {
            graphics.setBackground(new Color(255, 155, 155));
            graphics.clearRect(0, 0, tileSize.width, tileSize.height);
        }
        finally {
            graphics.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GridCoverage2D compute() {
        try {
            ReferencedEnvelope mapGeoBounds = this.bounds.toReferencedEnvelope(this.paintArea, this.dpi);
            CoordinateReferenceSystem mapProjection = mapGeoBounds.getCoordinateReferenceSystem();
            Dimension tileSizeOnScreen = this.tiledLayer.getTileSize();
            double layerDpi = this.tiledLayer.getLayerDpi() != null ? this.tiledLayer.getLayerDpi() : this.dpi;
            double layerResolution = this.tiledLayer.getScale().toResolution(mapProjection, layerDpi);
            Coordinate tileSizeInWorld = new Coordinate((double)tileSizeOnScreen.width * layerResolution, (double)tileSizeOnScreen.height * layerResolution);
            Coordinate gridCoverageOrigin = this.tiledLayer.getMinGeoCoordinate(mapGeoBounds, tileSizeInWorld);
            String commonUrl = this.tiledLayer.createCommonUrl();
            ReferencedEnvelope tileCacheBounds = this.tiledLayer.getTileCacheBounds();
            double resolution = this.tiledLayer.getScale().toResolution(this.bounds.getProjection(), layerDpi);
            double rowFactor = 1.0 / (resolution * (double)tileSizeOnScreen.height);
            double columnFactor = 1.0 / (resolution * (double)tileSizeOnScreen.width);
            int imageWidth = 0;
            int imageHeight = 0;
            int yIndex = (int)Math.floor((mapGeoBounds.getMaxY() - gridCoverageOrigin.y) / tileSizeInWorld.y) + 1;
            double gridCoverageMaxX = gridCoverageOrigin.x;
            double gridCoverageMaxY = gridCoverageOrigin.y;
            ArrayList loaderTasks = Lists.newArrayList();
            for (double geoY = gridCoverageOrigin.y; geoY < mapGeoBounds.getMaxY(); geoY += tileSizeInWorld.y) {
                --yIndex;
                imageHeight += tileSizeOnScreen.height;
                imageWidth = 0;
                int xIndex = -1;
                gridCoverageMaxX = gridCoverageOrigin.x;
                gridCoverageMaxY += tileSizeInWorld.y;
                for (double geoX = gridCoverageOrigin.x; geoX < mapGeoBounds.getMaxX(); geoX += tileSizeInWorld.x) {
                    ++xIndex;
                    imageWidth += tileSizeOnScreen.width;
                    gridCoverageMaxX += tileSizeInWorld.x;
                    ReferencedEnvelope tileBounds = new ReferencedEnvelope(geoX, geoX + tileSizeInWorld.x, geoY, geoY + tileSizeInWorld.y, mapProjection);
                    int row = (int)Math.round((tileCacheBounds.getMaxY() - tileBounds.getMaxY()) * rowFactor);
                    int column = (int)Math.round((tileBounds.getMinX() - tileCacheBounds.getMinX()) * columnFactor);
                    ClientHttpRequest tileRequest = this.tiledLayer.getTileRequest(this.httpRequestFactory, commonUrl, tileBounds, tileSizeOnScreen, column, row);
                    if (this.isInTileCacheBounds(tileCacheBounds, tileBounds)) {
                        if (!this.isTileVisible(tileBounds)) continue;
                        SingleTileLoaderTask task = new SingleTileLoaderTask(tileRequest, this.errorImage, xIndex, yIndex, this.failOnError);
                        loaderTasks.add(task);
                        continue;
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Tile out of bounds: " + tileRequest);
                    }
                    loaderTasks.add(new PlaceHolderImageTask(this.tiledLayer.getMissingTileImage(), xIndex, yIndex));
                }
            }
            BufferedImage coverageImage = this.tiledLayer.createBufferedImage(imageWidth, imageHeight);
            Graphics2D graphics = coverageImage.createGraphics();
            try {
                for (TileTask loaderTask : loaderTasks) {
                    Tile tile = (Tile)loaderTask.invoke();
                    if (Tile.access$000((Tile)tile) == null) continue;
                    graphics.drawImage((Image)Tile.access$000((Tile)tile), Tile.access$100((Tile)tile) * tileSizeOnScreen.width, Tile.access$200((Tile)tile) * tileSizeOnScreen.height, null);
                }
            }
            finally {
                graphics.dispose();
            }
            GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
            GeneralEnvelope gridEnvelope = new GeneralEnvelope(mapProjection);
            gridEnvelope.setEnvelope(new double[]{gridCoverageOrigin.x, gridCoverageOrigin.y, gridCoverageMaxX, gridCoverageMaxY});
            return factory.create((CharSequence)commonUrl.toString(), (RenderedImage)coverageImage, (org.opengis.geometry.Envelope)gridEnvelope, null, null, null);
        }
        catch (Exception e) {
            throw ExceptionUtils.getRuntimeException((Throwable)e);
        }
    }

    private boolean isInTileCacheBounds(ReferencedEnvelope tileCacheBounds, ReferencedEnvelope tilesBounds) {
        double boundsMinX = tilesBounds.getMinX();
        double boundsMinY = tilesBounds.getMinY();
        return boundsMinX >= tileCacheBounds.getMinX() && boundsMinX <= tileCacheBounds.getMaxX() && boundsMinY >= tileCacheBounds.getMinY() && boundsMinY <= tileCacheBounds.getMaxY();
    }

    private boolean isTileVisible(ReferencedEnvelope tileBounds) {
        if (FloatingPointUtil.equals((double)this.transformer.getRotation(), (double)0.0)) {
            return true;
        }
        GeometryFactory gfac = new GeometryFactory();
        Optional rotatedMapBounds = this.getRotatedMapBounds(gfac);
        if (rotatedMapBounds.isPresent()) {
            return ((Geometry)rotatedMapBounds.get()).intersects(gfac.toGeometry((Envelope)tileBounds));
        }
        return true;
    }

    private Optional<Geometry> getRotatedMapBounds(GeometryFactory gfac) {
        if (this.cachedRotatedMapBounds != null) {
            return this.cachedRotatedMapBounds;
        }
        ReferencedEnvelope mapBounds = this.transformer.getBounds().toReferencedEnvelope(new Rectangle(this.transformer.getMapSize()), this.dpi);
        Coordinate center = mapBounds.centre();
        AffineTransform affineTransform = AffineTransform.getRotateInstance(this.transformer.getRotation(), center.x, center.y);
        AffineTransform2D mathTransform = new AffineTransform2D(affineTransform);
        try {
            Geometry rotatedBounds = JTS.transform((Geometry)gfac.toGeometry((Envelope)mapBounds), (MathTransform)mathTransform);
            this.cachedRotatedMapBounds = Optional.of((Object)rotatedBounds);
        }
        catch (TransformException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failed to rotate map bounds: " + mapBounds.toString(), (Throwable)e);
            }
            this.cachedRotatedMapBounds = Optional.absent();
        }
        return this.cachedRotatedMapBounds;
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }
}

