/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled.osm;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.util.Assert;
import java.awt.Dimension;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Iterator;
import org.mapfish.print.map.tiled.AbstractTiledLayerParams;
import org.mapfish.print.parser.CanSatisfyOneOf;
import org.mapfish.print.parser.HasDefaultValue;
import org.mapfish.print.wrapper.PArray;
import org.mapfish.print.wrapper.PObject;

/*
 * Exception performing whole class analysis ignored.
 */
public final class OsmLayerParam
extends AbstractTiledLayerParams {
    private static final int NUMBER_OF_EXTENT_COORDS = 4;
    private static final double DEFAULT_RESOLUTION_TOLERANCE = 1.9;
    private static final int[] DEFAULT_TILE_SIZE = new int[]{256, 256};
    private static final double[] DEFAULT_MAX_EXTENT = new double[]{-2.003750834E7, -2.003750834E7, 2.003750834E7, 2.003750834E7};
    private static final Double[] DEFAULT_RESOLUTIONS = new Double[]{156543.03390625, 78271.516953125, 39135.7584765625, 19567.87923828125, 9783.939619140625, 4891.9698095703125, 2445.9849047851562, 1222.9924523925781, 611.4962261962891, 305.74811309814453, 152.87405654907226, 76.43702827453613, 38.218514137268066, 19.109257068634033, 9.554628534317017, 4.777314267158508, 2.388657133579254, 1.194328566789627, 0.5971642833948135};
    public String baseURL;
    @HasDefaultValue
    public double[] maxExtent = DEFAULT_MAX_EXTENT;
    @HasDefaultValue
    public int[] tileSize = DEFAULT_TILE_SIZE;
    @HasDefaultValue
    public Double[] resolutions = DEFAULT_RESOLUTIONS;
    @HasDefaultValue
    public double resolutionTolerance = 1.9;
    @HasDefaultValue
    public Double dpi = null;
    @HasDefaultValue
    @CanSatisfyOneOf(value="extension")
    public String imageExtension = "png";
    @CanSatisfyOneOf(value="extension")
    @Deprecated
    public String imageFormat = null;
    @HasDefaultValue
    public PObject customParams;
    private final Multimap<String, String> additionalCustomParam = HashMultimap.create();

    public Multimap<String, String> getCustomParams() {
        Multimap result = OsmLayerParam.convertToMultiMap((PObject)this.customParams);
        result.putAll(this.additionalCustomParam);
        return result;
    }

    public void setCustomParam(String name, String value) {
        this.additionalCustomParam.put((Object)name, (Object)value);
    }

    public void postConstruct() throws URISyntaxException {
        Assert.equals((Object)4, (Object)this.maxExtent.length, (String)("maxExtent must have exactly 4 elements to the array.  Was: " + Arrays.toString(this.maxExtent)));
        Assert.equals((Object)2, (Object)this.tileSize.length, (String)("tileSize must have exactly 2 elements to the array.  Was: " + Arrays.toString(this.tileSize)));
        Assert.isTrue((this.resolutions.length > 0 ? 1 : 0) != 0, (String)"resolutions must have at least one value");
        Arrays.sort(this.resolutions, Ordering.natural().reverse());
        Assert.isTrue((boolean)this.validateBaseUrl(), (String)"invalid baseURL");
    }

    public Envelope getMaxExtent() {
        boolean minX = false;
        boolean maxX = true;
        int minY = 2;
        int maxY = 3;
        return new Envelope(this.maxExtent[0], this.maxExtent[2], this.maxExtent[1], this.maxExtent[3]);
    }

    public String getBaseUrl() {
        return this.baseURL;
    }

    public Dimension getTileSize() {
        return new Dimension(this.tileSize[0], this.tileSize[1]);
    }

    public String createCommonUrl() {
        return this.getBaseUrl();
    }

    public boolean validateBaseUrl() {
        String url = this.getBaseUrl();
        if (Strings.isNullOrEmpty((String)url)) {
            return false;
        }
        url = url.replace("{z}", "0").replace("{x}", "0").replace("{y}", "0").replace("{-y}", "0");
        try {
            return new URI(url) != null;
        }
        catch (URISyntaxException exc) {
            return false;
        }
    }

    public static Multimap<String, String> convertToMultiMap(PObject objectParams) {
        HashMultimap params = HashMultimap.create();
        if (objectParams != null) {
            Iterator customParamsIter = objectParams.keys();
            while (customParamsIter.hasNext()) {
                String key = (String)customParamsIter.next();
                if (objectParams.isArray(key)) {
                    PArray array = objectParams.optArray(key);
                    for (int i = 0; i < array.size(); ++i) {
                        params.put((Object)key, (Object)array.getString(i));
                    }
                    continue;
                }
                params.put((Object)key, (Object)objectParams.optString(key, ""));
            }
        }
        return params;
    }
}

