/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled.wmts;

import java.awt.Rectangle;
import java.net.URI;
import java.net.URISyntaxException;
import jsr166y.ForkJoinPool;
import org.geotools.coverage.grid.GridCoverage2D;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.map.AbstractLayerParams;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.tiled.AbstractTiledLayer;
import org.mapfish.print.map.tiled.TileCacheInformation;
import org.mapfish.print.map.tiled.wmts.WMTSLayer;
import org.mapfish.print.map.tiled.wmts.WMTSLayerParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMTSLayer
extends AbstractTiledLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WMTSLayer.class);
    private final WMTSLayerParam param;

    protected WMTSLayer(ForkJoinPool executorService, StyleSupplier<GridCoverage2D> styleSupplier, WMTSLayerParam param) {
        super(executorService, styleSupplier, (AbstractLayerParams)param);
        this.param = param;
    }

    protected final TileCacheInformation createTileInformation(MapBounds bounds, Rectangle paintArea, double dpi, boolean isFirstLayer) {
        return new WMTSTileCacheInfo(this, bounds, paintArea, dpi);
    }

    public static URI createRestURI(String commonURL, String matrixId, int row, int col, WMTSLayerParam layerParam) throws URISyntaxException {
        String path = layerParam.baseURL;
        if (layerParam.dimensions != null) {
            for (int i = 0; i < layerParam.dimensions.length; ++i) {
                String dimension = layerParam.dimensions[i];
                String value = layerParam.dimensionParams.optString(dimension);
                if (value == null) {
                    value = layerParam.dimensionParams.getString(dimension.toUpperCase());
                }
                path = path.replace("{" + dimension + "}", value);
            }
        }
        path = path.replace("{TileMatrixSet}", layerParam.matrixSet);
        path = path.replace("{TileMatrix}", matrixId);
        path = path.replace("{TileRow}", String.valueOf(row));
        path = path.replace("{TileCol}", String.valueOf(col));
        path = path.replace("{style}", layerParam.style);
        path = path.replace("{Layer}", layerParam.layer);
        return new URI(path);
    }

    static /* synthetic */ WMTSLayerParam access$000(WMTSLayer x0) {
        return x0.param;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }
}

