/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.vividsolutions.jts.util.Assert;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.mapfish.print.parser.ParserUtils;
import org.mapfish.print.processor.CustomDependencies;
import org.mapfish.print.processor.InternalValue;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.ProcessorDependency;
import org.mapfish.print.processor.ProcessorDependencyGraph;
import org.mapfish.print.processor.ProcessorDependencyGraphFactory;
import org.mapfish.print.processor.ProcessorGraphNode;
import org.mapfish.print.processor.ProcessorUtils;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ProcessorDependencyGraphFactory {
    @Autowired
    private MetricRegistry metricRegistry;
    @Autowired(required=false)
    private List<ProcessorDependency> dependencies = Lists.newArrayList();

    public void setDependencies(List<ProcessorDependency> dependencies) {
        this.dependencies = dependencies;
    }

    public ProcessorDependencyGraph build(List<? extends Processor> processors) {
        ProcessorDependencyGraph graph = new ProcessorDependencyGraph();
        HashMap<String, ProcessorGraphNode> provideBy = new HashMap<String, ProcessorGraphNode>();
        HashMap<String, Class> outputTypes = new HashMap<String, Class>();
        ArrayList<ProcessorGraphNode> nodes = new ArrayList<ProcessorGraphNode>(processors.size());
        for (Processor processor : processors) {
            ProcessorGraphNode node = new ProcessorGraphNode(processor, this.metricRegistry);
            for (OutputValue value : ProcessorDependencyGraphFactory.getOutputValues((ProcessorGraphNode)node)) {
                String outputName = value.getName();
                if (provideBy.containsKey(outputName)) {
                    if (value.canBeRenamed()) {
                        outputName = outputName + "_" + UUID.randomUUID().toString();
                    } else {
                        throw new IllegalArgumentException("Multiple processors provide the same output mapping: '" + processor + "' and '" + provideBy.get(outputName) + "' both provide: '" + outputName + "'.  You have to rename one of the outputs and the corresponding input so that" + " there is no ambiguity with regards to the input a processor consumes.");
                    }
                }
                provideBy.put(outputName, node);
                outputTypes.put(outputName, value.getType());
            }
            nodes.add(node);
        }
        ArrayList allDependencies = Lists.newArrayList((Iterable)this.dependencies);
        for (ProcessorGraphNode node : nodes) {
            if (!(node.getProcessor() instanceof CustomDependencies)) continue;
            CustomDependencies custom = (CustomDependencies)node.getProcessor();
            allDependencies.addAll(custom.createDependencies(nodes));
        }
        SetMultimap setMultimap = this.cacheInputsForNodes(nodes);
        for (ProcessorGraphNode node : nodes) {
            Set inputs = setMultimap.get((Object)node);
            this.checkExternalDependencies((List)allDependencies, node, nodes);
            for (InputValue input : inputs) {
                Class outputType;
                ProcessorGraphNode solution = (ProcessorGraphNode)provideBy.get(input.getName());
                if (solution == null || solution == node) continue;
                Class inputType = input.getType();
                if (inputType.isAssignableFrom(outputType = (Class)outputTypes.get(input.getName()))) {
                    solution.addDependency(node);
                    continue;
                }
                throw new IllegalArgumentException("Type conflict: Processor '" + solution.getName() + "' provides an output with name '" + input.getName() + "' and of type '" + outputType + " ', while " + "processor '" + node.getName() + "' expects an input of that name with type '" + inputType + "'! Please rename one of the attributes in the mappings of the processors.");
            }
        }
        for (ProcessorGraphNode node : nodes) {
            if (node.hasRequirements() || !this.hasNoneOrOnlyExternalInput(node, setMultimap.get((Object)node), provideBy)) continue;
            graph.addRoot(node);
        }
        Assert.isTrue((boolean)graph.getAllProcessors().containsAll(processors), (String)("'" + graph + "' does not contain all the processors: " + processors));
        return graph;
    }

    private void checkExternalDependencies(List<ProcessorDependency> allDependencies, ProcessorGraphNode<Object, Object> node, List<ProcessorGraphNode<Object, Object>> nodes) {
        for (ProcessorDependency dependency : allDependencies) {
            if (!dependency.getRequired().equals(node.getProcessor().getClass())) continue;
            for (ProcessorGraphNode<Object, Object> dependentNode : nodes) {
                if (!dependency.getDependent().equals(dependentNode.getProcessor().getClass())) continue;
                if (dependency.getCommonInputs().isEmpty()) {
                    node.addDependency(dependentNode);
                    continue;
                }
                boolean allRequiredInputsInCommon = true;
                for (String requiredInput : dependency.getCommonInputs()) {
                    String requiredNodeInput = this.getRequiredNodeInput(requiredInput);
                    String dependentNodeInput = this.getDependentNodeInput(requiredInput);
                    String mappedKey = this.getMappedKey(node, requiredNodeInput);
                    if (this.getOriginalKey(dependentNode, mappedKey).equals(dependentNodeInput)) continue;
                    allRequiredInputsInCommon = false;
                    break;
                }
                if (!allRequiredInputsInCommon) continue;
                node.addDependency(dependentNode);
            }
        }
    }

    private String getDependentNodeInput(String requiredInput) {
        if (!requiredInput.contains(";")) {
            return requiredInput;
        }
        return requiredInput.substring(requiredInput.indexOf(";") + 1);
    }

    private String getRequiredNodeInput(String requiredInput) {
        if (!requiredInput.contains(";")) {
            return requiredInput;
        }
        return requiredInput.substring(0, requiredInput.indexOf(";"));
    }

    private String getMappedKey(ProcessorGraphNode<Object, Object> node, String requiredInput) {
        String inputName = requiredInput;
        if (node.getInputMapper().containsValue((Object)requiredInput)) {
            inputName = (String)node.getInputMapper().inverse().get((Object)requiredInput);
        }
        return inputName;
    }

    private String getOriginalKey(ProcessorGraphNode<Object, Object> node, String mappedKey) {
        String inputName = mappedKey;
        if (node.getInputMapper().containsKey((Object)mappedKey)) {
            inputName = (String)node.getInputMapper().get((Object)mappedKey);
        }
        return inputName;
    }

    private SetMultimap<ProcessorGraphNode<Object, Object>, InputValue> cacheInputsForNodes(List<ProcessorGraphNode<Object, Object>> nodes) {
        HashMultimap inputsForNodes = HashMultimap.create();
        for (ProcessorGraphNode<Object, Object> node : nodes) {
            Set inputs = ProcessorDependencyGraphFactory.getInputs(node);
            inputsForNodes.putAll(node, (Iterable)inputs);
        }
        return inputsForNodes;
    }

    private boolean hasNoneOrOnlyExternalInput(ProcessorGraphNode<Object, Object> node, Set<InputValue> inputs, Map<String, ProcessorGraphNode<Object, Object>> provideBy) {
        if (inputs.isEmpty()) {
            return true;
        }
        for (InputValue input : inputs) {
            ProcessorGraphNode<Object, Object> provider = provideBy.get(input.getName());
            if (provider == null || provider == node) continue;
            return false;
        }
        return true;
    }

    private static Set<InputValue> getInputs(ProcessorGraphNode<Object, Object> node) {
        BiMap inputMapper = node.getInputMapper();
        HashSet inputs = Sets.newHashSet();
        Object inputParameter = node.getProcessor().createInputParameter();
        if (inputParameter != null) {
            ProcessorDependencyGraphFactory.verifyAllMappingsMatchParameter((Set)inputMapper.values(), inputParameter.getClass(), (String)("One or more of the input mapping values of '" + node + "'  do not match an input parameter.  The bad mappings are"));
            Collection allProperties = ParserUtils.getAllAttributes(inputParameter.getClass());
            for (Field field : allProperties) {
                String name = ProcessorUtils.getInputValueName((String)node.getProcessor().getInputPrefix(), (BiMap)inputMapper, (String)field.getName());
                inputs.add(new InputValue(name, field.getType()));
            }
        }
        return inputs;
    }

    private static Collection<OutputValue> getOutputValues(ProcessorGraphNode<Object, Object> node) {
        BiMap outputMapper = node.getOutputMapper();
        HashSet values = Sets.newHashSet();
        Set mappings = outputMapper.keySet();
        Class paramType = node.getProcessor().getOutputType();
        ProcessorDependencyGraphFactory.verifyAllMappingsMatchParameter(mappings, (Class)paramType, (String)("One or more of the output mapping keys of '" + node + "' do not match an " + "output parameter.  The bad mappings are: "));
        Collection allProperties = ParserUtils.getAllAttributes((Class)paramType);
        for (Field field : allProperties) {
            boolean canBeRenamed = field.getAnnotation(InternalValue.class) != null;
            String name = ProcessorUtils.getOutputValueName((String)node.getProcessor().getOutputPrefix(), (Map)outputMapper, (Field)field);
            values.add(new OutputValue(name, canBeRenamed, field.getType(), null));
        }
        return values;
    }

    private static void verifyAllMappingsMatchParameter(Set<String> mappings, Class<?> paramType, String errorMessagePrefix) {
        Set attributeNames = ParserUtils.getAllAttributeNames(paramType);
        StringBuilder errors = new StringBuilder();
        for (String mapping : mappings) {
            if (attributeNames.contains(mapping)) continue;
            errors.append("\n  * ").append(mapping);
        }
        Assert.isTrue((0 == errors.length() ? 1 : 0) != 0, (String)(errorMessagePrefix + errors + ProcessorDependencyGraphFactory.listOptions((Set)attributeNames) + "\n"));
    }

    private static String listOptions(Set<String> attributeNames) {
        StringBuilder msg = new StringBuilder("\n\nThe possible parameter names are:");
        for (String attributeName : attributeNames) {
            msg.append("\n  * ").append(attributeName);
        }
        return msg.toString();
    }
}

