/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Optional;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.ProcessorExecutionContext;
import org.mapfish.print.processor.ProcessorGraphNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessorGraphNode<In, Out> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessorGraphNode.class);
    private final Processor<In, Out> processor;
    private final List<ProcessorGraphNode<?, ?>> dependencies = Lists.newArrayList();
    private final List<ProcessorGraphNode<?, ?>> requirements = Lists.newArrayList();
    private final MetricRegistry metricRegistry;

    public ProcessorGraphNode(@Nonnull Processor<In, Out> processor, @Nonnull MetricRegistry metricRegistry) {
        this.processor = processor;
        this.metricRegistry = metricRegistry;
    }

    public Processor<?, ?> getProcessor() {
        return this.processor;
    }

    public void addDependency(ProcessorGraphNode node) {
        this.dependencies.add(node);
        node.addRequirement(this);
    }

    private void addRequirement(ProcessorGraphNode node) {
        this.requirements.add(node);
    }

    protected List<ProcessorGraphNode<?, ?>> getRequirements() {
        return this.requirements;
    }

    public boolean hasRequirements() {
        return !this.requirements.isEmpty();
    }

    public Optional<ProcessorNodeForkJoinTask> createTask(@Nonnull ProcessorExecutionContext execContext) {
        if (!execContext.tryStart(this)) {
            return Optional.absent();
        }
        return Optional.of((Object)new ProcessorNodeForkJoinTask(this, execContext, null));
    }

    @Nonnull
    public BiMap<String, String> getOutputMapper() {
        BiMap outputMapper = this.processor.getOutputMapperBiMap();
        if (outputMapper == null) {
            return HashBiMap.create();
        }
        return outputMapper;
    }

    @Nonnull
    public BiMap<String, String> getInputMapper() {
        BiMap inputMapper = this.processor.getInputMapperBiMap();
        if (inputMapper == null) {
            return HashBiMap.create();
        }
        return inputMapper;
    }

    public void toString(StringBuilder builder, int indent) {
        int spaces = indent * 2;
        for (int i = 0; i < spaces; ++i) {
            builder.append(' ');
        }
        if (indent > 0) {
            builder.append("+-- ");
        }
        builder.append(this.processor);
        for (ProcessorGraphNode dependency : this.dependencies) {
            builder.append('\n');
            dependency.toString(builder, indent + 1);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder, 0);
        return builder.toString();
    }

    public String getName() {
        return this.processor.toString();
    }

    public Set<? extends Processor<?, ?>> getAllProcessors() {
        IdentityHashMap all = new IdentityHashMap();
        all.put(this.getProcessor(), null);
        for (ProcessorGraphNode dependency : this.dependencies) {
            for (Processor p : dependency.getAllProcessors()) {
                all.put(p, null);
            }
        }
        return all.keySet();
    }

    static /* synthetic */ Processor access$100(ProcessorGraphNode x0) {
        return x0.processor;
    }

    static /* synthetic */ MetricRegistry access$200(ProcessorGraphNode x0) {
        return x0.metricRegistry;
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }

    static /* synthetic */ List access$400(ProcessorGraphNode x0) {
        return x0.dependencies;
    }
}

