/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor;

import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.output.Values;
import org.mapfish.print.parser.HasDefaultValue;
import org.mapfish.print.parser.ParserUtils;
import org.mapfish.print.processor.Processor;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ProcessorUtils {
    private ProcessorUtils() {
    }

    public static <In, Out> In populateInputParameter(Processor<In, Out> processor, Values values) {
        Object inputObject = processor.createInputParameter();
        if (inputObject instanceof Values) {
            Values castValues = values;
            return (In)castValues;
        }
        if (inputObject != null) {
            Collection fields = ParserUtils.getAllAttributes(inputObject.getClass());
            for (Field field : fields) {
                String name = ProcessorUtils.getInputValueName((String)processor.getOutputPrefix(), (BiMap)processor.getInputMapperBiMap(), (String)field.getName());
                Object value = null;
                if (field.getType() == Values.class) {
                    value = values;
                } else if (values != null) {
                    value = values.getObject(name, Object.class);
                }
                if (value != null) {
                    try {
                        field.set(inputObject, value);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw ExceptionUtils.getRuntimeException((Throwable)e);
                    }
                }
                if (field.getAnnotation(HasDefaultValue.class) != null) continue;
                throw new NoSuchElementException(name + " or " + field.getName() + " is a required property for " + processor + " and therefore must be defined in the Request Data or be an output of one" + " of the other processors. Available values: " + values == null ? null : values.asMap().keySet() + ".");
            }
        }
        return (In)inputObject;
    }

    public static void writeProcessorOutputToValues(Object output, Processor<?, ?> processor, Values values) {
        Object mapper = processor.getOutputMapperBiMap();
        if (mapper == null) {
            mapper = Collections.emptyMap();
        }
        Collection fields = ParserUtils.getAllAttributes(output.getClass());
        for (Field field : fields) {
            String name = ProcessorUtils.getOutputValueName((String)processor.getOutputPrefix(), (Map)mapper, (Field)field);
            try {
                Object value = field.get(output);
                if (value != null) {
                    values.put(name, value);
                    continue;
                }
                values.remove(name);
            }
            catch (IllegalAccessException e) {
                throw ExceptionUtils.getRuntimeException((Throwable)e);
            }
        }
    }

    public static String getInputValueName(@Nullable String inputPrefix, @Nonnull BiMap<String, String> inputMapper, @Nonnull String field) {
        String name;
        String string = name = inputMapper == null ? null : (String)inputMapper.inverse().get((Object)field);
        if (name == null) {
            if (inputMapper != null && inputMapper.containsKey((Object)field)) {
                throw new RuntimeException("field in keys");
            }
            String[] defaultValues = new String[]{"tempTaskDirectory", "clientHttpRequestFactory", "template", "pdfConfig", "SUBREPORT_DIR"};
            name = inputPrefix == null || Arrays.asList(defaultValues).contains(field) ? field : inputPrefix.trim() + Character.toUpperCase(field.charAt(0)) + field.substring(1);
        }
        return name;
    }

    public static String getOutputValueName(@Nullable String outputPrefix, @Nonnull Map<String, String> outputMapper, @Nonnull Field field) {
        String name = outputMapper.get(field.getName());
        if (name == null) {
            name = field.getName();
            if (!Strings.isNullOrEmpty((String)outputPrefix) && !outputPrefix.trim().isEmpty()) {
                name = outputPrefix.trim() + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            }
        }
        return name;
    }
}

