/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.http;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.output.Values;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.ProcessorUtils;
import org.mapfish.print.processor.http.ClientHttpFactoryProcessorParam;
import org.mapfish.print.processor.http.HttpProcessor;

public final class CompositeClientHttpRequestFactoryProcessor
extends AbstractProcessor<Values, ClientHttpFactoryProcessorParam>
implements HttpProcessor<Values> {
    private List<HttpProcessor> httpProcessors = Lists.newArrayList();

    protected CompositeClientHttpRequestFactoryProcessor() {
        super(ClientHttpFactoryProcessorParam.class);
    }

    public void setHttpProcessors(List<HttpProcessor> httpProcessors) {
        this.httpProcessors = httpProcessors;
    }

    public MfClientHttpRequestFactory createFactoryWrapper(Values values, MfClientHttpRequestFactory requestFactory) {
        MfClientHttpRequestFactory finalRequestFactory = requestFactory;
        for (int i = this.httpProcessors.size() - 1; i > -1; --i) {
            HttpProcessor processor = (HttpProcessor)this.httpProcessors.get(i);
            Object input = ProcessorUtils.populateInputParameter((Processor)processor, (Values)values);
            finalRequestFactory = processor.createFactoryWrapper(input, finalRequestFactory);
        }
        return finalRequestFactory;
    }

    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
        if (this.httpProcessors.isEmpty()) {
            validationErrors.add(new IllegalStateException("There are no composite elements for this processor"));
        } else {
            for (Object part : this.httpProcessors) {
                if (part instanceof HttpProcessor) continue;
                validationErrors.add(new IllegalStateException("One of the parts of " + this.getClass().getSimpleName() + " is not a " + HttpProcessor.class.getSimpleName()));
            }
        }
    }

    @Nullable
    public Values createInputParameter() {
        return new Values();
    }

    @Nullable
    public ClientHttpFactoryProcessorParam execute(Values values, Processor.ExecutionContext context) throws Exception {
        MfClientHttpRequestFactory requestFactory = (MfClientHttpRequestFactory)values.getObject("clientHttpRequestFactory", MfClientHttpRequestFactory.class);
        ClientHttpFactoryProcessorParam output = new ClientHttpFactoryProcessorParam();
        output.clientHttpRequestFactory = this.createFactoryWrapper(values, requestFactory);
        return output;
    }
}

