/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.http;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mapfish.print.RegexpUtil;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.processor.http.AbstractClientHttpRequestFactoryProcessor;
import org.mapfish.print.processor.http.ClientHttpFactoryProcessorParam;

public final class UseHttpForHttpsProcessor
extends AbstractClientHttpRequestFactoryProcessor {
    private static final int HTTPS_STANDARD_PORT = 443;
    private static final int HTTP_STANDARD_PORT = 80;
    private static final int JAVA_HTTPS_STANDARD_PORT = 8443;
    private static final int JAVA_HTTP_STANDARD_PORT = 8080;
    private static final Pattern HTTP_AUTHORITY_PORT_EXTRACTOR = Pattern.compile("(.*@)?.*:(\\d+)");
    private static final Pattern HTTP_AUTHORITY_HOST_EXTRACTOR = Pattern.compile("(.*@)?([^:]*)(:\\d+)?");
    private Map<Integer, Integer> portMapping = Maps.newHashMap();
    private List<Pattern> hosts = Lists.newArrayList();

    protected UseHttpForHttpsProcessor() {
        this.portMapping.put(443, 80);
        this.portMapping.put(8443, 8080);
    }

    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
        super.extraValidation(validationErrors, configuration);
        if (this.hosts.isEmpty()) {
            validationErrors.add(new IllegalArgumentException("No hosts are registered"));
        }
    }

    public MfClientHttpRequestFactory createFactoryWrapper(ClientHttpFactoryProcessorParam clientHttpFactoryProcessorParam, MfClientHttpRequestFactory requestFactory) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void setPortMapping(Map<Integer, Integer> portMapping) {
        this.portMapping.putAll(portMapping);
    }

    public void setHosts(List<String> hosts) {
        this.hosts.clear();
        for (String host : hosts) {
            this.hosts.add(RegexpUtil.compilePattern((String)host));
        }
    }

    private boolean matchingHost(String host) {
        for (Pattern hostPattern : this.hosts) {
            if (!hostPattern.matcher(host).matches()) continue;
            return true;
        }
        return false;
    }

    private URI updatePortAndScheme(URI uri) throws URISyntaxException {
        int port = uri.getPort();
        if (this.portMapping.containsKey(port)) {
            port = (Integer)this.portMapping.get(port);
        }
        URI httpUri = new URI("http", uri.getUserInfo(), uri.getHost(), port, uri.getPath(), uri.getQuery(), uri.getFragment());
        return httpUri;
    }

    private URI updatePortAndSchemeInAuthority(URI uri) throws URISyntaxException {
        String authority = uri.getAuthority();
        Matcher matcher = HTTP_AUTHORITY_PORT_EXTRACTOR.matcher(uri.getAuthority());
        if (matcher.matches()) {
            int port = Integer.parseInt(matcher.group(2));
            authority = authority.substring(0, matcher.start(2));
            if (this.portMapping.containsKey(port)) {
                port = (Integer)this.portMapping.get(port);
            }
            authority = authority + port;
        }
        URI httpUri = new URI("http", authority, uri.getPath(), uri.getQuery(), uri.getFragment());
        return httpUri;
    }

    static /* synthetic */ Pattern access$000() {
        return HTTP_AUTHORITY_HOST_EXTRACTOR;
    }

    static /* synthetic */ boolean access$100(UseHttpForHttpsProcessor x0, String x1) {
        return x0.matchingHost(x1);
    }

    static /* synthetic */ URI access$200(UseHttpForHttpsProcessor x0, URI x1) throws URISyntaxException {
        return x0.updatePortAndSchemeInAuthority(x1);
    }

    static /* synthetic */ URI access$300(UseHttpForHttpsProcessor x0, URI x1) throws URISyntaxException {
        return x0.updatePortAndScheme(x1);
    }
}

