/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.jasper;

import com.google.common.annotations.Beta;
import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.parser.ParserUtils;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.CustomDependencies;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.ProcessorDependency;
import org.mapfish.print.processor.ProcessorGraphNode;
import org.mapfish.print.processor.jasper.MergeDataSourceProcessor;

/*
 * Exception performing whole class analysis ignored.
 */
@Beta
public final class MergeDataSourceProcessor
extends AbstractProcessor<In, Out>
implements CustomDependencies {
    private List<Source> sources = Lists.newArrayList();

    protected MergeDataSourceProcessor() {
        super(Out.class);
    }

    public void setSources(List<Source> sources) {
        this.sources = sources;
    }

    protected void extraValidation(List<Throwable> validationErrors, Configuration config) {
        if (this.sources == null || this.sources.isEmpty()) {
            validationErrors.add((Throwable)new ConfigurationException(this.getClass().getSimpleName() + " needs to have at minimum a single source. " + "Although logically it should have more"));
            return;
        }
        for (int i = 0; i < this.sources.size(); ++i) {
            Source source = (Source)this.sources.get(i);
            if (source.type == null) {
                validationErrors.add((Throwable)new ConfigurationException("The " + MergeDataSourceProcessor.indexString((int)i) + " source in " + this.getClass().getSimpleName() + " needs to " + "have a 'type' parameter defined."));
                continue;
            }
            source.type.validate(i, validationErrors, source);
        }
    }

    @Nullable
    public In createInputParameter() {
        return new In();
    }

    @Nullable
    public Out execute(In values, Processor.ExecutionContext context) throws Exception {
        ArrayList rows = Lists.newArrayList();
        for (Source source : this.sources) {
            source.type.add((List)rows, values.values, source);
        }
        JRMapCollectionDataSource mergedDataSource = new JRMapCollectionDataSource((Collection)rows);
        return new Out((JRDataSource)mergedDataSource);
    }

    @Nonnull
    public List<ProcessorDependency> createDependencies(@Nonnull List<ProcessorGraphNode<Object, Object>> nodes) {
        HashSet sourceKeys = Sets.newHashSet();
        for (Source source : this.sources) {
            source.type.addValuesKeys(source, sourceKeys);
        }
        ArrayList dependencies = Lists.newArrayList();
        for (ProcessorGraphNode<Object, Object> node : nodes) {
            if (node.getProcessor() == this) continue;
            Processor processor = node.getProcessor();
            Collection allAttributes = ParserUtils.getAllAttributes((Class)processor.getOutputType());
            BiMap outputMapper = node.getOutputMapper();
            ProcessorDependency customDependency = null;
            for (Field allAttribute : allAttributes) {
                String attributeName = allAttribute.getName();
                String mappedName = (String)outputMapper.get((Object)attributeName);
                if (mappedName != null) {
                    attributeName = mappedName;
                }
                if (!sourceKeys.contains(attributeName)) continue;
                if (customDependency == null) {
                    Class<?> processorClass = processor.getClass();
                    customDependency = new ProcessorDependency(processorClass, this.getClass(), Collections.singleton(attributeName));
                    dependencies.add(customDependency);
                    continue;
                }
                customDependency.addCommonInput(attributeName);
            }
        }
        return dependencies;
    }

    private static String indexString(int i) {
        switch (i + 1) {
            case 1: {
                return "1st";
            }
            case 2: {
                return "2nd";
            }
        }
        return i + 1 + "th";
    }

    static /* synthetic */ String access$100(int x0) {
        return MergeDataSourceProcessor.indexString((int)x0);
    }
}

