/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.mapfish.print.attribute.DataSourceAttribute;
import org.mapfish.print.attribute.map.AreaOfInterest;
import org.mapfish.print.attribute.map.MapAttribute;
import org.mapfish.print.attribute.map.PagingAttribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.map.DistanceUnit;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.map.CreateMapPagesProcessor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateMapPagesProcessor
extends AbstractProcessor<Input, Output> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateMapPagesProcessor.class);
    private static final int DO_NOT_RENDER_BBOX_INDEX = -1;
    private final GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();

    protected CreateMapPagesProcessor() {
        super(Output.class);
    }

    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
    }

    public final Input createInputParameter() {
        return new Input();
    }

    public final Output execute(Input values, Processor.ExecutionContext context) throws Exception {
        MapAttribute.MapAttributeValues map = values.map;
        PagingAttribute.PagingProcessorValues paging = values.paging;
        CoordinateReferenceSystem projection = map.getMapBounds().getProjection();
        Rectangle paintArea = new Rectangle(map.getMapSize());
        double dpi = map.getRequestorDPI();
        DistanceUnit projectionUnit = DistanceUnit.fromProjection((CoordinateReferenceSystem)projection);
        AreaOfInterest areaOfInterest = map.areaOfInterest;
        if (areaOfInterest == null) {
            areaOfInterest = new AreaOfInterest();
            areaOfInterest.display = AreaOfInterest.AoiDisplay.NONE;
            ReferencedEnvelope mapBBox = map.getMapBounds().toReferencedEnvelope(paintArea, dpi);
            areaOfInterest.setPolygon(this.geometryFactory.toGeometry((Envelope)mapBBox));
        }
        Envelope aoiBBox = areaOfInterest.getArea().getEnvelopeInternal();
        double paintAreaWidthIn = paintArea.getWidth() * paging.scale / dpi;
        double paintAreaHeightIn = paintArea.getHeight() * paging.scale / dpi;
        double paintAreaWidth = DistanceUnit.IN.convertTo(paintAreaWidthIn, projectionUnit);
        double paintAreaHeight = DistanceUnit.IN.convertTo(paintAreaHeightIn, projectionUnit);
        double overlapProj = DistanceUnit.IN.convertTo(paging.overlap * paging.scale / dpi, projectionUnit);
        int nbWidth = (int)Math.ceil((aoiBBox.getWidth() + overlapProj) / (paintAreaWidth - overlapProj));
        int nbHeight = (int)Math.ceil((aoiBBox.getHeight() + overlapProj) / (paintAreaHeight - overlapProj));
        double marginWidth = (paintAreaWidth * (double)nbWidth - (double)(nbWidth - 1) * overlapProj - aoiBBox.getWidth()) / 2.0;
        double marginHeight = (paintAreaHeight * (double)nbHeight - (double)(nbHeight - 1) * overlapProj - aoiBBox.getHeight()) / 2.0;
        double minX = aoiBBox.getMinX() - marginWidth - overlapProj / 2.0;
        double minY = aoiBBox.getMinY() - marginHeight - overlapProj / 2.0;
        LOGGER.info("Paging generate a grid of " + nbWidth + "x" + nbHeight + " potential maps.");
        int[][] mapIndexes = new int[nbWidth][nbHeight];
        Envelope[][] mapsBounds = new Envelope[nbWidth][nbHeight];
        int mapIndex = 0;
        for (int j = 0; j < nbHeight; ++j) {
            for (int i = 0; i < nbWidth; ++i) {
                double x1 = minX + (double)i * (paintAreaWidth - overlapProj);
                double x2 = x1 + paintAreaWidth;
                double y1 = minY + (double)j * (paintAreaHeight - overlapProj);
                double y2 = y1 + paintAreaHeight;
                Coordinate[] coords = new Coordinate[]{new Coordinate(x1, y1), new Coordinate(x1, y2), new Coordinate(x2, y2), new Coordinate(x2, y1), new Coordinate(x1, y1)};
                LinearRing ring = this.geometryFactory.createLinearRing(coords);
                Polygon bbox = this.geometryFactory.createPolygon(ring);
                if (areaOfInterest.getArea().intersects((Geometry)bbox)) {
                    mapsBounds[i][j] = bbox.getEnvelopeInternal();
                    mapIndexes[i][j] = mapIndex++;
                    continue;
                }
                mapIndexes[i][j] = -1;
            }
        }
        ArrayList mapList = Lists.newArrayList();
        for (int j = 0; j < nbHeight; ++j) {
            for (int i = 0; i < nbWidth; ++i) {
                if (mapIndexes[i][j] == -1) continue;
                HashMap<String, Integer> mapValues = new HashMap<String, Integer>();
                mapValues.put("name", mapIndexes[i][j]);
                mapValues.put("left", i != 0 ? mapIndexes[i - 1][j] : -1);
                mapValues.put("bottom", j != 0 ? mapIndexes[i][j - 1] : -1);
                mapValues.put("right", i != nbWidth - 1 ? mapIndexes[i + 1][j] : -1);
                mapValues.put("top", j != nbHeight - 1 ? mapIndexes[i][j + 1] : -1);
                Envelope mapsBound = mapsBounds[i][j];
                MapAttribute.MapAttributeValues theMap = map.copy(map.getMapSize(), (Function)new /* Unavailable Anonymous Inner Class!! */);
                mapValues.put("map", (Integer)theMap);
                mapList.add(mapValues);
            }
        }
        LOGGER.info("Paging generate " + mapList.size() + " maps definitions.");
        DataSourceAttribute.DataSourceAttributeValue datasourceAttributes = new DataSourceAttribute.DataSourceAttributeValue();
        datasourceAttributes.attributesValues = mapList.toArray(new Map[mapList.size()]);
        return new Output(datasourceAttributes, null);
    }
}

