/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.jasper.ImagesSubReport;
import org.mapfish.print.processor.map.CreateNorthArrowProcessor;
import org.mapfish.print.processor.map.NorthArrowGraphic;

public class CreateNorthArrowProcessor
extends AbstractProcessor<Input, Output> {
    protected CreateNorthArrowProcessor() {
        super(Output.class);
    }

    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
    }

    public final Input createInputParameter() {
        return new Input();
    }

    public final Output execute(Input values, Processor.ExecutionContext context) throws Exception {
        this.checkCancelState(context);
        double dpiRatio = values.map.getDpi() / values.map.getRequestorDPI();
        Dimension size = new Dimension((int)(values.northArrow.getSize().getWidth() * dpiRatio), (int)(values.northArrow.getSize().getHeight() * dpiRatio));
        URI northArrowGraphicFile = NorthArrowGraphic.create((Dimension)size, (String)values.northArrow.getGraphic(), (Color)values.northArrow.getBackgroundColor(), (Double)values.map.getRotation(), (File)values.tempTaskDirectory, (MfClientHttpRequestFactory)values.clientHttpRequestFactory);
        this.checkCancelState(context);
        URI scalebarSubReport = this.createNorthArrowSubReport(values.tempTaskDirectory, values.northArrow.getSize(), (List)Lists.newArrayList((Object[])new URI[]{northArrowGraphicFile}), values.map.getDpi().doubleValue());
        return new Output(northArrowGraphicFile, scalebarSubReport.toString(), null);
    }

    private URI createNorthArrowSubReport(File printDirectory, Dimension size, List<URI> graphics, double dpi) throws IOException, JRException {
        ImagesSubReport subReport = new ImagesSubReport(graphics, size, dpi);
        File compiledReport = File.createTempFile("north-arrow-report-", ".jasper", printDirectory);
        subReport.compile(compiledReport);
        return compiledReport.toURI();
    }
}

