/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map.scalebar;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.mapfish.print.attribute.ScalebarAttribute;
import org.mapfish.print.processor.map.scalebar.Label;
import org.mapfish.print.processor.map.scalebar.Orientation;
import org.mapfish.print.processor.map.scalebar.ScaleBarRenderSettings;
import org.mapfish.print.processor.map.scalebar.ScalebarDrawer;

public abstract class ScalebarDrawer {
    private final Graphics2D graphics2d;
    private final ScaleBarRenderSettings settings;
    private final ScalebarAttribute.ScalebarAttributeValues params;

    public ScalebarDrawer(Graphics2D graphics2d, ScaleBarRenderSettings settings) {
        this.graphics2d = graphics2d;
        this.settings = settings;
        this.params = settings.getParams();
    }

    public final void draw() {
        AffineTransform transform = this.getAlignmentTransform();
        this.graphics2d.setTransform(transform);
        this.graphics2d.setColor(this.params.getBackgroundColor());
        this.graphics2d.fillRect(0, 0, this.settings.getSize().width, this.settings.getSize().height);
        AffineTransform labelTransform = new AffineTransform(transform);
        this.setLabelTranslate(labelTransform);
        this.graphics2d.setTransform(labelTransform);
        this.graphics2d.setColor(this.params.getFontColor());
        this.drawLabels(this.params.getOrientation());
        AffineTransform lineTransform = new AffineTransform(transform);
        this.setLineTranslate(lineTransform);
        if (this.params.getOrientation() == Orientation.VERTICAL_LABELS_LEFT || this.params.getOrientation() == Orientation.VERTICAL_LABELS_RIGHT) {
            AffineTransform rotate = AffineTransform.getQuadrantRotateInstance(1);
            lineTransform.concatenate(rotate);
        }
        this.graphics2d.setTransform(lineTransform);
        this.graphics2d.setStroke(new BasicStroke(this.settings.getLineWidth()));
        this.graphics2d.setColor(this.params.getColor());
        this.drawBar();
    }

    private AffineTransform getAlignmentTransform() {
        int offsetY;
        int offsetX;
        switch (1.$SwitchMap$org$mapfish$print$processor$map$scalebar$HorizontalAlign[this.settings.getParams().getAlign().ordinal()]) {
            case 1: {
                offsetX = 0;
                break;
            }
            case 2: {
                offsetX = this.settings.getMaxSize().width - this.settings.getSize().width;
                break;
            }
            default: {
                offsetX = (int)Math.floor((double)this.settings.getMaxSize().width / 2.0 - (double)this.settings.getSize().width / 2.0);
            }
        }
        switch (1.$SwitchMap$org$mapfish$print$processor$map$scalebar$VerticalAlign[this.settings.getParams().getVerticalAlign().ordinal()]) {
            case 1: {
                offsetY = 0;
                break;
            }
            case 2: {
                offsetY = this.settings.getMaxSize().height - this.settings.getSize().height;
                break;
            }
            default: {
                offsetY = (int)Math.floor((double)this.settings.getMaxSize().height / 2.0 - (double)this.settings.getSize().height / 2.0);
            }
        }
        return AffineTransform.getTranslateInstance(offsetX, offsetY);
    }

    private void setLineTranslate(AffineTransform lineTransform) {
        if (this.params.getOrientation() == Orientation.HORIZONTAL_LABELS_BELOW) {
            lineTransform.translate((float)this.settings.getPadding() + this.settings.getLeftLabelMargin(), this.settings.getPadding() + this.settings.getBarSize());
        } else if (this.params.getOrientation() == Orientation.HORIZONTAL_LABELS_ABOVE) {
            lineTransform.translate((float)this.settings.getPadding() + this.settings.getLeftLabelMargin(), this.settings.getPadding() + this.settings.getBarSize() + this.settings.getLabelDistance() + this.settings.getMaxLabelSize().height);
        } else if (this.params.getOrientation() == Orientation.VERTICAL_LABELS_LEFT) {
            lineTransform.translate(this.settings.getPadding() + this.settings.getMaxLabelSize().width + this.settings.getLabelDistance(), (float)this.settings.getPadding() + this.settings.getTopLabelMargin());
        } else if (this.params.getOrientation() == Orientation.VERTICAL_LABELS_RIGHT) {
            lineTransform.translate(this.settings.getPadding(), (float)this.settings.getPadding() + this.settings.getTopLabelMargin());
        }
    }

    private void setLabelTranslate(AffineTransform labelTransform) {
        if (this.params.getOrientation() == Orientation.HORIZONTAL_LABELS_BELOW) {
            labelTransform.translate((float)this.settings.getPadding() + this.settings.getLeftLabelMargin(), this.settings.getPadding() + this.settings.getBarSize() + this.settings.getLabelDistance() + this.settings.getMaxLabelSize().height);
        } else if (this.params.getOrientation() == Orientation.HORIZONTAL_LABELS_ABOVE) {
            labelTransform.translate((float)this.settings.getPadding() + this.settings.getLeftLabelMargin(), this.settings.getPadding() + this.settings.getMaxLabelSize().height);
        } else if (this.params.getOrientation() == Orientation.VERTICAL_LABELS_LEFT) {
            labelTransform.translate(this.settings.getPadding(), (float)this.settings.getPadding() + this.settings.getTopLabelMargin());
        } else if (this.params.getOrientation() == Orientation.VERTICAL_LABELS_RIGHT) {
            labelTransform.translate(this.settings.getPadding() + this.settings.getBarSize() + this.settings.getLabelDistance(), (float)this.settings.getPadding() + this.settings.getTopLabelMargin());
        }
    }

    protected abstract void drawBar();

    private float getTotalLength(Orientation orientation) {
        if (orientation.isHorizontal()) {
            return this.settings.getIntervalLengthInPixels() * (float)this.params.intervals.intValue() + this.settings.getLeftLabelMargin() + this.settings.getRightLabelMargin();
        }
        return this.settings.getIntervalLengthInPixels() * (float)this.params.intervals.intValue() + this.settings.getTopLabelMargin() + this.settings.getBottomLabelMargin();
    }

    private void drawLabels(Orientation orientation) {
        float prevPos = this.getTotalLength(orientation);
        for (int i = this.settings.getLabels().size() - 1; i >= 0; --i) {
            float newPos;
            boolean shouldSkipLabel;
            float posY;
            float posX;
            Label label = (Label)this.settings.getLabels().get(i);
            if (orientation.isHorizontal()) {
                float offsetH = -label.getWidth() / 2.0f;
                posX = label.getGraphicOffset() + offsetH;
                posY = 0.0f;
                shouldSkipLabel = label.getGraphicOffset() + Math.abs(offsetH) > prevPos - 1.0f;
                newPos = label.getGraphicOffset() - Math.abs(offsetH);
            } else {
                float offsetV = label.getHeight() / 2.0f;
                posX = orientation == Orientation.VERTICAL_LABELS_LEFT ? (float)this.settings.getMaxLabelSize().width - label.getWidth() : 0.0f;
                posY = label.getGraphicOffset() + offsetV;
                shouldSkipLabel = label.getGraphicOffset() + offsetV > prevPos - 1.0f;
                newPos = label.getGraphicOffset() - Math.abs(offsetV);
            }
            if (shouldSkipLabel) continue;
            label.getLabelLayout().draw(this.graphics2d, posX, posY);
            prevPos = newPos;
        }
    }

    public final Graphics2D getGraphics2d() {
        return this.graphics2d;
    }

    public final ScaleBarRenderSettings getSettings() {
        return this.settings;
    }

    public final ScalebarAttribute.ScalebarAttributeValues getParams() {
        return this.params;
    }
}

