/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mapfish.print.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class BaseMapServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseMapServlet.class);
    protected static final Logger SPEC_LOGGER = LoggerFactory.getLogger((String)(BaseMapServlet.class.getPackage().getName() + ".spec"));

    protected static String cleanUpName(String original) {
        return original.replace(",", "").replaceAll("\\s+", "_");
    }

    public static String findReplacement(String variableName, Date date) {
        if (variableName.equalsIgnoreCase("date")) {
            return BaseMapServlet.cleanUpName((String)DateFormat.getDateInstance().format(date));
        }
        if (variableName.equalsIgnoreCase("datetime")) {
            return BaseMapServlet.cleanUpName((String)DateFormat.getDateTimeInstance().format(date));
        }
        if (variableName.equalsIgnoreCase("time")) {
            return BaseMapServlet.cleanUpName((String)DateFormat.getTimeInstance().format(date));
        }
        try {
            return new SimpleDateFormat(variableName).format(date);
        }
        catch (Exception e) {
            LOGGER.error("Unable to format timestamp according to pattern: " + variableName, (Throwable)e);
            return "${" + variableName + "}";
        }
    }

    protected static final void error(HttpServletResponse httpServletResponse, String message, HttpStatus code) {
        PrintWriter out = null;
        try {
            httpServletResponse.setContentType("text/plain");
            httpServletResponse.setStatus(code.value());
            out = httpServletResponse.getWriter();
            out.println("Error while processing request:");
            out.println(message);
            LOGGER.error("Error while processing request: " + message);
        }
        catch (IOException ex) {
            throw ExceptionUtils.getRuntimeException((Throwable)ex);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    protected final void error(HttpServletResponse httpServletResponse, Throwable e) {
        PrintWriter out = null;
        try {
            httpServletResponse.setContentType("text/plain");
            httpServletResponse.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            out = httpServletResponse.getWriter();
            out.println("Error while processing request:");
            e.printStackTrace(out);
            LOGGER.error("Error while processing request", e);
        }
        catch (IOException ex) {
            throw ExceptionUtils.getRuntimeException((Throwable)ex);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    protected final StringBuilder getBaseUrl(HttpServletRequest httpServletRequest) {
        StringBuilder baseURL = new StringBuilder();
        if (httpServletRequest.getContextPath() != null && !httpServletRequest.getContextPath().isEmpty()) {
            baseURL.append(httpServletRequest.getContextPath());
        }
        if (httpServletRequest.getServletPath() != null && !httpServletRequest.getServletPath().isEmpty()) {
            baseURL.append(httpServletRequest.getServletPath());
        }
        return baseURL;
    }
}

