/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.fileloader;

import com.google.common.base.Optional;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.servlet.fileloader.ConfigFileLoaderPlugin;
import org.mapfish.print.servlet.fileloader.FileConfigFileLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClasspathConfigFileLoader
implements ConfigFileLoaderPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathConfigFileLoader.class);
    private static final String PREFIX = "classpath";
    private static final int PREFIX_LENGTH = "classpath://".length();

    public Optional<File> toFile(URI fileUri) {
        Optional urlOptional = this.loadResources(fileUri);
        if (urlOptional.isPresent() && ((URL)urlOptional.get()).getProtocol().equalsIgnoreCase("file")) {
            try {
                return Optional.of((Object)new File(((URL)urlOptional.get()).toURI()));
            }
            catch (URISyntaxException e) {
                return Optional.absent();
            }
        }
        return Optional.absent();
    }

    public String getUriScheme() {
        return PREFIX;
    }

    public Optional<Long> lastModified(URI fileURI) {
        Optional resources = this.loadResources(fileURI);
        if (resources.isPresent()) {
            URL url = (URL)resources.get();
            if (url.getProtocol().equalsIgnoreCase("file")) {
                try {
                    return Optional.of((Object)new File(url.toURI()).lastModified());
                }
                catch (URISyntaxException e) {
                    throw ExceptionUtils.getRuntimeException((Throwable)e);
                }
            }
            return Optional.absent();
        }
        throw new NoSuchElementException(fileURI + " does not exist");
    }

    public boolean isAccessible(URI fileURI) {
        Optional resources = this.loadResources(fileURI);
        return resources.isPresent();
    }

    public byte[] loadFile(URI fileURI) throws IOException {
        Optional resources = this.loadResources(fileURI);
        if (resources.isPresent()) {
            return Resources.toByteArray((URL)((URL)resources.get()));
        }
        throw new NoSuchElementException(fileURI + " does not exist");
    }

    public boolean isAccessible(URI configFileUri, String pathToSubResource) {
        try {
            Optional child = this.resolveChild(configFileUri, pathToSubResource);
            return child.isPresent();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public byte[] loadFile(URI configFileUri, String pathToSubResource) throws IOException {
        Optional child = this.resolveChild(configFileUri, pathToSubResource);
        if (child.isPresent()) {
            return Resources.toByteArray((URL)((URL)child.get()));
        }
        throw new NoSuchElementException("No file is found for parameters: '" + configFileUri + "' and subresource: '" + pathToSubResource + "'");
    }

    private Optional<URL> resolveChild(URI configFileUri, String pathToSubResource) {
        Optional found;
        Optional urlOptional = this.loadResources(configFileUri);
        if (!urlOptional.isPresent()) {
            throw new NoSuchElementException("Configuration file '" + configFileUri + "' does not exist");
        }
        String configUriAsString = configFileUri.toString();
        String configFileName = configUriAsString.substring(configUriAsString.lastIndexOf(47) + 1);
        String configFileDir = ((URL)urlOptional.get()).toString();
        configFileDir = configFileDir.substring(0, configFileDir.indexOf(configFileName));
        if (pathToSubResource.startsWith(PREFIX) && (found = this.resolveChildAsUri(configFileUri, pathToSubResource, configFileDir)).isPresent()) {
            return found;
        }
        try {
            if (pathToSubResource.contains(":/")) {
                URI uri = new URI(pathToSubResource);
                throw new IllegalArgumentException("Only uris with prefix classpath are supported.  Found: " + uri);
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        String subResourceRelativeToConfigFileDir = configUriAsString.substring(0, configUriAsString.indexOf(configFileName)) + pathToSubResource;
        return this.resolveChildAsUri(configFileUri, subResourceRelativeToConfigFileDir, configFileDir);
    }

    private Optional<URL> resolveChildAsUri(URI configFileUri, String pathToSubResource, String configFileDir) {
        try {
            Optional subResource = this.loadResources(new URI(pathToSubResource));
            if (subResource.isPresent()) {
                if (!((URL)subResource.get()).toString().startsWith(configFileDir)) {
                    throw new IllegalArgumentException("'" + pathToSubResource + "' is not a child of '" + configFileUri + "'");
                }
                return Optional.of((Object)subResource.get());
            }
        }
        catch (URISyntaxException e) {
            return Optional.absent();
        }
        return Optional.absent();
    }

    private Optional<URL> loadResources(URI fileURI) {
        if (fileURI == null) {
            return Optional.absent();
        }
        if (fileURI.getScheme() != null && fileURI.getScheme().equals("file")) {
            File file;
            try {
                file = new File(fileURI);
            }
            catch (IllegalArgumentException e) {
                file = new File(fileURI.toString().substring("file://".length()));
            }
            if (file.exists()) {
                try {
                    return Optional.of((Object)file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw ExceptionUtils.getRuntimeException((Throwable)e);
                }
            }
            return Optional.absent();
        }
        if (!fileURI.toString().startsWith(PREFIX)) {
            return Optional.absent();
        }
        String path = fileURI.toString().substring(PREFIX_LENGTH);
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        try {
            Enumeration<URL> resources = FileConfigFileLoader.class.getClassLoader().getResources(path);
            if (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                return Optional.of((Object)resource);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Unable to find resources on the path: " + fileURI);
        }
        return Optional.absent();
    }
}

