/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.net.URI;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.mapfish.print.MapPrinter;
import org.mapfish.print.MapPrinterFactory;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.config.access.AccessAssertion;
import org.mapfish.print.config.access.AndAccessAssertion;
import org.mapfish.print.output.OutputFormat;
import org.mapfish.print.servlet.job.FailedPrintJob;
import org.mapfish.print.servlet.job.PrintJob;
import org.mapfish.print.servlet.job.PrintJobStatus;
import org.mapfish.print.servlet.job.SuccessfulPrintJob;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class PrintJob
implements Callable<PrintJobStatus> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrintJob.class);
    private String referenceId;
    private PJsonObject requestData;
    private AccessAssertion access;
    private Long createTime;
    @Autowired
    private MapPrinterFactory mapPrinterFactory;
    @Autowired
    private MetricRegistry metricRegistry;
    @Autowired
    private ApplicationContext applicationContext;
    private SecurityContext securityContext;

    public final String getReferenceId() {
        return this.referenceId;
    }

    public final void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public final Long getCreateTime() {
        return this.createTime;
    }

    public final Date getCreateTimeAsDate() {
        return new Date(this.createTime);
    }

    public final void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public final void setRequestData(PJsonObject requestData) {
        this.requestData = requestData;
    }

    protected abstract URI withOpenOutputStream(PrintAction var1) throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final PrintJobStatus call() throws Exception {
        SecurityContextHolder.setContext((SecurityContext)this.securityContext);
        Timer.Context timer = this.metricRegistry.timer(this.getClass().getName() + " call()").time();
        PJsonObject spec = null;
        MapPrinter mapPrinter = null;
        try {
            LOGGER.info("Starting print job " + this.referenceId);
            spec = this.requestData;
            MapPrinter finalMapPrinter = mapPrinter = this.mapPrinterFactory.create(this.getAppId());
            URI reportURI = this.withOpenOutputStream((PrintAction)new /* Unavailable Anonymous Inner Class!! */);
            this.metricRegistry.counter(this.getClass().getName() + "success").inc();
            LOGGER.info("Successfully completed print job " + this.referenceId);
            LOGGER.debug("Job " + this.referenceId + "\n" + this.requestData);
            String fileName = PrintJob.getFileName((MapPrinter)mapPrinter, (PJsonObject)spec);
            OutputFormat outputFormat = mapPrinter.getOutputFormat(spec);
            String mimeType = outputFormat.getContentType();
            String fileExtension = outputFormat.getFileSuffix();
            SuccessfulPrintJob successfulPrintJob = new SuccessfulPrintJob(this.referenceId, reportURI, this.getAppId(), this.getCreateTimeAsDate(), new Date(), 0L, fileName, mimeType, fileExtension, this.access);
            return successfulPrintJob;
        }
        catch (Throwable e) {
            String canceledText = "";
            if (Thread.currentThread().isInterrupted()) {
                canceledText = "(canceled) ";
            }
            LOGGER.info("Error executing print job " + canceledText + this.referenceId + "\n" + this.requestData, e);
            this.metricRegistry.counter(this.getClass().getName() + "failure").inc();
            String fileName = "unknownFileName";
            if (spec != null) {
                fileName = PrintJob.getFileName((MapPrinter)mapPrinter, (PJsonObject)spec);
            }
            Throwable rootCause = this.getRootCause(e);
            FailedPrintJob failedPrintJob = new FailedPrintJob(this.referenceId, this.getAppId(), this.getCreateTimeAsDate(), new Date(), 0L, fileName, rootCause.toString(), false, this.access);
            return failedPrintJob;
        }
        finally {
            long stop = TimeUnit.MILLISECONDS.convert(timer.stop(), TimeUnit.NANOSECONDS);
            LOGGER.debug("Print Job " + this.referenceId + " completed in " + stop + "ms");
        }
    }

    private Throwable getRootCause(Throwable e) {
        Throwable rootCause;
        for (rootCause = e; rootCause.getCause() != null && rootCause.getCause() != rootCause; rootCause = rootCause.getCause()) {
        }
        return rootCause;
    }

    protected final String getAppId() {
        return this.requestData.optString("app", "default");
    }

    private static String getFileName(@Nullable MapPrinter mapPrinter, PJsonObject spec) {
        String fileName = spec.optString("outputFilename");
        if (fileName != null) {
            return fileName;
        }
        if (mapPrinter != null) {
            String templateName;
            Configuration config = mapPrinter.getConfiguration();
            Template template = config.getTemplate(templateName = spec.getString("layout"));
            if (template.getOutputFilename() != null) {
                return template.getOutputFilename();
            }
            if (config.getOutputFilename() != null) {
                return config.getOutputFilename();
            }
        }
        return "mapfish-print-report";
    }

    public final void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = SecurityContextHolder.createEmptyContext();
        this.securityContext.setAuthentication(securityContext.getAuthentication());
    }

    public final AccessAssertion getAccess() {
        return this.access;
    }

    public final void configureAccess(Template template) {
        Configuration configuration = template.getConfiguration();
        AndAccessAssertion accessAssertion = (AndAccessAssertion)this.applicationContext.getBean(AndAccessAssertion.class);
        accessAssertion.setPredicates(new AccessAssertion[]{configuration.getAccessAssertion(), template.getAccessAssertion()});
        this.access = accessAssertion;
    }

    final void initForTesting(ApplicationContext context) {
        this.applicationContext = context;
        this.metricRegistry = (MetricRegistry)context.getBean(MetricRegistry.class);
        this.mapPrinterFactory = new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ PJsonObject access$000(PrintJob x0) {
        return x0.requestData;
    }
}

