/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job;

import com.google.common.base.Optional;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.config.access.AccessAssertion;
import org.mapfish.print.config.access.AccessAssertionPersister;
import org.mapfish.print.servlet.job.FailedPrintJob;
import org.mapfish.print.servlet.job.NoSuchReferenceException;
import org.mapfish.print.servlet.job.PendingPrintJob;
import org.mapfish.print.servlet.job.SuccessfulPrintJob;
import org.mapfish.print.servlet.registry.Registry;

public abstract class PrintJobStatus {
    private static final String RESULT_METADATA = "resultMetadata_";
    private static final String JSON_APP = "appId";
    private static final String JSON_FILENAME = "fileName";
    private static final String JSON_SUCCESS = "success";
    private static final String JSON_ACCESS_ASSERTION = "access";
    private static final String JSON_START_DATE = "startDate";
    private static final String JSON_COMPLETION_DATE = "completionDate";
    private static final String JSON_REQUEST_COUNT = "requestCount";
    private final String referenceId;
    private final String appId;
    private final String fileName;
    private Date startDate;
    private Date completionDate;
    private long requestCount;
    private final AccessAssertion access;

    public PrintJobStatus(String referenceId, String appId, Date startDate, Date completionDate, long requestCount, String fileName, AccessAssertion accessAssertion) {
        this.referenceId = referenceId;
        this.appId = appId;
        this.startDate = startDate;
        this.completionDate = completionDate;
        this.requestCount = requestCount;
        this.fileName = fileName;
        this.access = accessAssertion;
    }

    public final void assertAccess() {
        this.access.assertAccess(this.getClass().getSimpleName() + " for app '" + this.appId + "' for print job '" + this.referenceId + "'", (Object)this);
    }

    public final void store(Registry registry, AccessAssertionPersister persister) throws JSONException {
        JSONObject metadata = new JSONObject();
        metadata.put(JSON_APP, (Object)this.appId);
        metadata.put(JSON_FILENAME, (Object)this.fileName);
        metadata.put(JSON_SUCCESS, this instanceof SuccessfulPrintJob);
        metadata.put(JSON_START_DATE, this.startDate.getTime());
        metadata.put(JSON_REQUEST_COUNT, this.requestCount);
        if (this.completionDate != null) {
            metadata.put(JSON_COMPLETION_DATE, this.completionDate.getTime());
        }
        metadata.put(JSON_ACCESS_ASSERTION, (Object)persister.marshal(this.access));
        this.addExtraParameters(metadata);
        registry.put(RESULT_METADATA + this.referenceId, metadata);
    }

    protected abstract void addExtraParameters(JSONObject var1) throws JSONException;

    public static Optional<? extends PrintJobStatus> load(String referenceId, Registry registry, AccessAssertionPersister persister) throws JSONException, NoSuchReferenceException {
        if (registry.containsKey(RESULT_METADATA + referenceId)) {
            Object report;
            JSONObject metadata = registry.getJSON(RESULT_METADATA + referenceId);
            String appId = metadata.optString(JSON_APP, null);
            Date startDate = new Date(metadata.getLong(JSON_START_DATE));
            long requestCount = metadata.getLong(JSON_REQUEST_COUNT);
            JSONObject accessJSON = metadata.getJSONObject(JSON_ACCESS_ASSERTION);
            AccessAssertion accessAssertion = persister.unmarshal(accessJSON);
            if (!metadata.has(JSON_COMPLETION_DATE)) {
                report = PendingPrintJob.load((JSONObject)metadata, (String)referenceId, (String)appId, (Date)startDate, (long)requestCount, (AccessAssertion)accessAssertion);
            } else {
                String fileName = metadata.getString(JSON_FILENAME);
                Date completionDate = new Date(metadata.getLong(JSON_COMPLETION_DATE));
                report = metadata.getBoolean(JSON_SUCCESS) ? SuccessfulPrintJob.load((JSONObject)metadata, (String)referenceId, (String)appId, (Date)startDate, (Date)completionDate, (long)requestCount, (String)fileName, (AccessAssertion)accessAssertion) : FailedPrintJob.load((JSONObject)metadata, (String)referenceId, (String)appId, (Date)startDate, (Date)completionDate, (long)requestCount, (String)fileName, (AccessAssertion)accessAssertion);
            }
            return Optional.of((Object)report);
        }
        throw new NoSuchReferenceException("invalid reference '" + referenceId + "'");
    }

    public final String getReferenceId() {
        return this.referenceId;
    }

    public final String getAppId() {
        return this.appId;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final Date getStartDate() {
        return this.startDate;
    }

    public final void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }

    public final Date getCompletionDate() {
        return this.completionDate;
    }

    public final long getRequestCount() {
        return this.requestCount;
    }

    public final AccessAssertion getAccess() {
        return this.access;
    }

    public final long getElapsedTime() {
        if (this.completionDate == null) {
            return new Date().getTime() - this.startDate.getTime();
        }
        return this.completionDate.getTime() - this.startDate.getTime();
    }
}

