/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job;

import com.google.common.base.Optional;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.json.JSONException;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.config.WorkingDirectories;
import org.mapfish.print.config.access.AccessAssertionPersister;
import org.mapfish.print.servlet.job.FailedPrintJob;
import org.mapfish.print.servlet.job.JobManager;
import org.mapfish.print.servlet.job.JobStatus;
import org.mapfish.print.servlet.job.NoSuchReferenceException;
import org.mapfish.print.servlet.job.PendingPrintJob;
import org.mapfish.print.servlet.job.PrintJob;
import org.mapfish.print.servlet.job.PrintJobStatus;
import org.mapfish.print.servlet.job.SubmittedPrintJob;
import org.mapfish.print.servlet.job.ThreadPoolJobManager;
import org.mapfish.print.servlet.registry.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class ThreadPoolJobManager
implements JobManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadPoolJobManager.class);
    private static final String REPORT_URI_PREFIX = "REPORT_URI_";
    private static final String NEW_PRINT_COUNT = "newPrintCount";
    private static final String LAST_PRINT_COUNT = "lastPrintCount";
    private static final String TOTAL_PRINT_TIME = "totalPrintTime";
    private static final String NB_PRINT_DONE = "nbPrintDone";
    private static final String LAST_POLL = "lastPoll_";
    private static final int DEFAULT_MAX_WAITING_JOBS = 5000;
    private static final long DEFAULT_THREAD_IDLE_TIME = 60L;
    private static final long DEFAULT_TIMEOUT_IN_SECONDS = 600L;
    private static final long DEFAULT_ABANDONED_TIMEOUT_IN_SECONDS = 120L;
    private static final boolean DEFAULT_OLD_FILES_CLEAN_UP = true;
    private static final long DEFAULT_CLEAN_UP_INTERVAL_IN_SECONDS = 86400L;
    private int maxNumberOfRunningPrintJobs = Runtime.getRuntime().availableProcessors();
    private int maxNumberOfWaitingJobs = 5000;
    private long maxIdleTime = 60L;
    private long timeout = 600L;
    private long abandonedTimeout = 120L;
    private boolean oldFileCleanUp = true;
    private long oldFileCleanupInterval = 86400L;
    private Comparator<PrintJob> jobPriorityComparator = new /* Unavailable Anonymous Inner Class!! */;
    private ThreadPoolExecutor executor;
    private final Map<String, SubmittedPrintJob> runningTasksFutures = Collections.synchronizedMap(new HashMap());
    @Autowired
    private Registry registry;
    private PriorityBlockingQueue<Runnable> queue;
    private ScheduledExecutorService timer;
    private ScheduledExecutorService cleanUpTimer;
    @Qualifier(value="accessAssertionPersister")
    @Autowired
    private AccessAssertionPersister assertionPersister;
    @Autowired
    private WorkingDirectories workingDirectories;

    public final void setMaxNumberOfRunningPrintJobs(int maxNumberOfRunningPrintJobs) {
        this.maxNumberOfRunningPrintJobs = maxNumberOfRunningPrintJobs;
    }

    public final void setMaxNumberOfWaitingJobs(int maxNumberOfWaitingJobs) {
        this.maxNumberOfWaitingJobs = maxNumberOfWaitingJobs;
    }

    public final void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public final void setAbandonedTimeout(long abandonedTimeout) {
        this.abandonedTimeout = abandonedTimeout;
    }

    public final void setJobPriorityComparator(Comparator<PrintJob> jobPriorityComparator) {
        this.jobPriorityComparator = jobPriorityComparator;
    }

    public final void setOldFileCleanUp(boolean oldFileCleanUp) {
        this.oldFileCleanUp = oldFileCleanUp;
    }

    public final void setOldFileCleanupInterval(long oldFileCleanupInterval) {
        this.oldFileCleanupInterval = oldFileCleanupInterval;
    }

    @PostConstruct
    public final void init() {
        if (TimeUnit.SECONDS.toMillis(this.abandonedTimeout) >= this.registry.getTimeToKeepAfterAccessInMillis()) {
            String msg = String.format("%s abandonTimeout must be smaller than %s timeToKeepAfterAccess", this.getClass().getName(), this.registry.getClass().getName());
            throw new IllegalStateException(msg);
        }
        if (TimeUnit.SECONDS.toMillis(this.timeout) >= this.registry.getTimeToKeepAfterAccessInMillis()) {
            String msg = String.format("%s timeout must be smaller than %s timeToKeepAfterAccess", this.getClass().getName(), this.registry.getClass().getName());
            throw new IllegalStateException(msg);
        }
        CustomizableThreadFactory threadFactory = new CustomizableThreadFactory();
        threadFactory.setDaemon(true);
        threadFactory.setThreadNamePrefix("PrintJobManager-");
        this.queue = new PriorityBlockingQueue(this.maxNumberOfWaitingJobs, new /* Unavailable Anonymous Inner Class!! */);
        this.executor = new /* Unavailable Anonymous Inner Class!! */;
        this.timer = Executors.newScheduledThreadPool(1, (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);
        this.timer.scheduleAtFixedRate((Runnable)new PostResultToRegistryTask(this, this.assertionPersister), 500L, 500L, TimeUnit.MILLISECONDS);
        if (this.oldFileCleanUp) {
            this.cleanUpTimer = Executors.newScheduledThreadPool(1, (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);
            this.cleanUpTimer.scheduleAtFixedRate(this.workingDirectories.getCleanUpTask(), 0L, this.oldFileCleanupInterval, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAsRunning(String referenceId) {
        Registry registry = this.registry;
        synchronized (registry) {
            try {
                Optional jobStatus = PrintJobStatus.load((String)referenceId, (Registry)this.registry, (AccessAssertionPersister)this.assertionPersister);
                if (jobStatus.get() instanceof PendingPrintJob) {
                    PendingPrintJob job = (PendingPrintJob)jobStatus.get();
                    job.setRunning(true);
                    job.store(this.registry, this.assertionPersister);
                }
            }
            catch (JSONException e) {
                LOGGER.error("failed to mark job as running", (Throwable)e);
            }
            catch (NoSuchReferenceException e) {
                LOGGER.error("tried to mark non-existing job as 'running': " + referenceId, (Throwable)e);
            }
        }
    }

    @PreDestroy
    public final void shutdown() {
        this.timer.shutdownNow();
        this.executor.shutdownNow();
    }

    public final void submit(PrintJob job) {
        int numberOfWaitingRequests = this.queue.size();
        if (numberOfWaitingRequests >= this.maxNumberOfWaitingJobs) {
            throw new RuntimeException("Max. number of waiting print job requests exceeded.  Number of waiting requests are: " + numberOfWaitingRequests);
        }
        this.registry.incrementInt(NEW_PRINT_COUNT, 1);
        try {
            Date startDate = job.getCreateTimeAsDate();
            PendingPrintJob pendingPrintJob = new PendingPrintJob(job.getReferenceId(), job.getAppId(), startDate, (long)this.getNumberOfRequestsMade(), job.getAccess());
            pendingPrintJob.assertAccess();
            pendingPrintJob.store(this.registry, this.assertionPersister);
            this.registry.put(LAST_POLL + job.getReferenceId(), (Number)new Date().getTime());
            LOGGER.info("Submitted print job " + job.getReferenceId());
        }
        catch (JSONException e) {
            throw ExceptionUtils.getRuntimeException((Throwable)e);
        }
        finally {
            Future future = this.executor.submit(job);
            this.runningTasksFutures.put(job.getReferenceId(), new SubmittedPrintJob(future, job.getReferenceId(), job.getAppId(), job.getAccess()));
        }
    }

    public final int getNumberOfRequestsMade() {
        return (Integer)this.registry.opt(NEW_PRINT_COUNT, (Object)0);
    }

    public final boolean isDone(String referenceId) throws NoSuchReferenceException {
        boolean done = this.getCompletedPrintJob(referenceId).isPresent();
        if (!done) {
            this.registry.put(LAST_POLL + referenceId, (Number)new Date().getTime());
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel(String referenceId) throws NoSuchReferenceException {
        SubmittedPrintJob printJob;
        Optional jobStatus = null;
        try {
            jobStatus = PrintJobStatus.load((String)referenceId, (Registry)this.registry, (AccessAssertionPersister)this.assertionPersister);
        }
        catch (JSONException e) {
            throw ExceptionUtils.getRuntimeException((Throwable)e);
        }
        Map e = this.runningTasksFutures;
        synchronized (e) {
            if (this.runningTasksFutures.containsKey(referenceId)) {
                printJob = (SubmittedPrintJob)this.runningTasksFutures.get(referenceId);
                if (!printJob.getReportFuture().cancel(true)) {
                    LOGGER.info("Could not cancel job " + referenceId);
                }
                this.runningTasksFutures.remove(referenceId);
                this.registry.incrementInt(NB_PRINT_DONE, 1);
                this.registry.incrementLong(TOTAL_PRINT_TIME, printJob.getTimeSinceStart());
            }
        }
        FailedPrintJob failedJob = new FailedPrintJob(referenceId, ((PrintJobStatus)jobStatus.get()).getAppId(), ((PrintJobStatus)jobStatus.get()).getStartDate(), new Date(), ((PrintJobStatus)jobStatus.get()).getRequestCount(), "", "task cancelled", true, ((PrintJobStatus)jobStatus.get()).getAccess());
        try {
            printJob = this.registry;
            synchronized (printJob) {
                failedJob.store(this.registry, this.assertionPersister);
            }
        }
        catch (JSONException e2) {
            throw ExceptionUtils.getRuntimeException((Throwable)e2);
        }
    }

    public final long timeSinceLastStatusCheck(String referenceId) {
        return (Long)this.registry.opt(LAST_POLL + referenceId, (Object)System.currentTimeMillis());
    }

    public final long getAverageTimeSpentPrinting() {
        return (Long)this.registry.opt(TOTAL_PRINT_TIME, (Object)0L) / ((Integer)this.registry.opt(NB_PRINT_DONE, (Object)1)).longValue();
    }

    public final int getLastPrintCount() {
        return (Integer)this.registry.opt(LAST_PRINT_COUNT, (Object)0);
    }

    public final Optional<? extends PrintJobStatus> getCompletedPrintJob(String referenceId) throws NoSuchReferenceException {
        try {
            Optional jobStatus = PrintJobStatus.load((String)referenceId, (Registry)this.registry, (AccessAssertionPersister)this.assertionPersister);
            if (jobStatus.get() instanceof PendingPrintJob) {
                return Optional.absent();
            }
            ((PrintJobStatus)jobStatus.get()).assertAccess();
            return jobStatus;
        }
        catch (JSONException e) {
            throw ExceptionUtils.getRuntimeException((Throwable)e);
        }
    }

    public final JobStatus getStatus(String referenceId) throws NoSuchReferenceException {
        PrintJobStatus jobStatus = null;
        try {
            jobStatus = (PrintJobStatus)PrintJobStatus.load((String)referenceId, (Registry)this.registry, (AccessAssertionPersister)this.assertionPersister).get();
            jobStatus.assertAccess();
        }
        catch (JSONException e) {
            throw ExceptionUtils.getRuntimeException((Throwable)e);
        }
        boolean done = true;
        String error = "";
        long elapsedTime = jobStatus.getElapsedTime();
        long waitingTime = 0L;
        JobStatus.Status status = JobStatus.Status.FINISHED;
        if (jobStatus instanceof PendingPrintJob) {
            PendingPrintJob pendingJob = (PendingPrintJob)jobStatus;
            done = false;
            status = pendingJob.isRunning() ? JobStatus.Status.RUNNING : JobStatus.Status.WAITING;
        } else if (jobStatus instanceof FailedPrintJob) {
            FailedPrintJob failedJob = (FailedPrintJob)jobStatus;
            error = failedJob.getError();
            JobStatus.Status status2 = status = failedJob.getCancelled() ? JobStatus.Status.CANCELLED : JobStatus.Status.ERROR;
        }
        if (status == JobStatus.Status.WAITING) {
            long requestsMadeAtStart = jobStatus.getRequestCount();
            long finishedJobs = this.getLastPrintCount();
            long jobsRunningOrInQueue = requestsMadeAtStart - finishedJobs;
            long jobsInQueue = jobsRunningOrInQueue - (long)this.maxNumberOfRunningPrintJobs;
            long queuePosition = jobsInQueue / (long)this.maxNumberOfRunningPrintJobs;
            waitingTime = Math.max(0L, queuePosition * this.getAverageTimeSpentPrinting());
        }
        if (!done) {
            this.registry.put(LAST_POLL + referenceId, (Number)new Date().getTime());
        }
        return new JobStatus(done, error, elapsedTime, status, waitingTime);
    }

    static /* synthetic */ Comparator access$000(ThreadPoolJobManager x0) {
        return x0.jobPriorityComparator;
    }

    static /* synthetic */ void access$100(ThreadPoolJobManager x0, String x1) {
        x0.markAsRunning(x1);
    }

    static /* synthetic */ ThreadPoolExecutor access$200(ThreadPoolJobManager x0) {
        return x0.executor;
    }

    static /* synthetic */ Map access$300(ThreadPoolJobManager x0) {
        return x0.runningTasksFutures;
    }

    static /* synthetic */ Logger access$400() {
        return LOGGER;
    }

    static /* synthetic */ Registry access$500(ThreadPoolJobManager x0) {
        return x0.registry;
    }

    static /* synthetic */ long access$600(ThreadPoolJobManager x0) {
        return x0.timeout;
    }

    static /* synthetic */ long access$700(ThreadPoolJobManager x0) {
        return x0.abandonedTimeout;
    }
}

