/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.oldapi;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.config.OldApiConfig;
import org.mapfish.print.servlet.oldapi.OldAPILayerConverter;
import org.mapfish.print.wrapper.json.PJsonObject;

public final class OldAPILayerConverter {
    private static Map<String, LayerConverter> converters = new HashMap();

    private OldAPILayerConverter() {
    }

    public static JSONObject convert(PJsonObject oldLayer, OldApiConfig oldApi) throws JSONException {
        String layerType = oldLayer.optString("type", "").toLowerCase();
        if (!converters.containsKey(layerType)) {
            throw new UnsupportedOperationException("Layer type '" + layerType + "' is " + "not supported by the legacy API.");
        }
        return ((LayerConverter)converters.get(layerType)).convert(oldLayer, oldApi);
    }

    static {
        converters.put("osm", new OSMConverter(null));
        converters.put("xyz", new OSMConverter(null));
        converters.put("wms", new WMSConverter(null));
        converters.put("wmts", new WMSTConverter(null));
        converters.put("vector", new GeoJsonConverter(null));
    }
}

