/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.registry;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.servlet.registry.Registry;

public class BasicRegistry
implements Registry {
    private static final int TIME_TO_KEEP_AFTER_ACCESS = 30;
    private Cache<String, Object> registry;
    private int timeToKeepAfterAccessInMinutes = 30;

    public final void setTimeToKeepAfterAccessInMinutes(int timeToKeepAfterAccessInMinutes) {
        this.timeToKeepAfterAccessInMinutes = timeToKeepAfterAccessInMinutes;
    }

    @PostConstruct
    private void init() {
        this.registry = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess((long)this.timeToKeepAfterAccessInMinutes, TimeUnit.MINUTES).build();
    }

    public final long getTimeToKeepAfterAccessInMillis() {
        return TimeUnit.MINUTES.toMillis(this.timeToKeepAfterAccessInMinutes);
    }

    public final synchronized boolean containsKey(String key) {
        return this.registry.getIfPresent((Object)key) != null;
    }

    public final synchronized void put(String key, URI value) {
        this.registry.put((Object)key, (Object)value);
    }

    public final synchronized long incrementLong(String key, long amount) {
        long newValue = (Long)this.opt(key, (Object)0L) + amount;
        this.put(key, (Number)newValue);
        return newValue;
    }

    public final synchronized int incrementInt(String key, int amount) {
        int newValue = (Integer)this.opt(key, (Object)0) + amount;
        this.put(key, (Number)newValue);
        return newValue;
    }

    public final synchronized URI getURI(String key) {
        return (URI)this.registry.getIfPresent((Object)key);
    }

    public final synchronized void put(String key, String value) {
        this.registry.put((Object)key, (Object)value);
    }

    public final synchronized String getString(String key) {
        return (String)this.registry.getIfPresent((Object)key);
    }

    public final synchronized void put(String key, Number value) {
        this.registry.put((Object)key, (Object)value);
    }

    public final synchronized Number getNumber(String key) {
        return (Number)this.registry.getIfPresent((Object)key);
    }

    public final synchronized <T> T opt(String key, T defaultValue) {
        Object value = this.registry.getIfPresent((Object)key);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public final synchronized void put(String key, JSONObject value) {
        this.registry.put((Object)key, (Object)value.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized JSONObject getJSON(String key) {
        String source;
        BasicRegistry basicRegistry = this;
        synchronized (basicRegistry) {
            source = (String)this.registry.getIfPresent((Object)key);
        }
        try {
            return new JSONObject(source);
        }
        catch (JSONException e) {
            throw ExceptionUtils.getRuntimeException((Throwable)e);
        }
    }
}

