/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.wrapper.json;

import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mapfish.print.wrapper.ObjectMissingException;
import org.mapfish.print.wrapper.PAbstractObject;
import org.mapfish.print.wrapper.PArray;
import org.mapfish.print.wrapper.PElement;
import org.mapfish.print.wrapper.PObject;
import org.mapfish.print.wrapper.json.PJsonArray;

public class PJsonObject
extends PAbstractObject {
    private final JSONObject obj;

    public PJsonObject(JSONObject obj, String contextName) {
        this(null, obj, contextName);
    }

    public PJsonObject(PElement parent, JSONObject obj, String contextName) {
        super(parent, contextName);
        this.obj = obj;
    }

    public final Object opt(String key) {
        return this.obj.opt(key);
    }

    public final String optString(String key) {
        return this.obj.optString(key, null);
    }

    public final Integer optInt(String key) {
        int result = this.obj.optInt(key, Integer.MIN_VALUE);
        return result == Integer.MIN_VALUE ? null : Integer.valueOf(result);
    }

    public final Long optLong(String key) {
        long result = this.obj.optLong(key, Long.MIN_VALUE);
        return result == Long.MIN_VALUE ? null : Long.valueOf(result);
    }

    public final Double optDouble(String key) {
        double result = this.obj.optDouble(key, Double.NaN);
        if (Double.isNaN(result)) {
            return null;
        }
        return result;
    }

    public final Float optFloat(String key) {
        double result = this.obj.optDouble(key, Double.NaN);
        if (Double.isNaN(result)) {
            return null;
        }
        return Float.valueOf((float)result);
    }

    public final Boolean optBool(String key) {
        if (this.obj.optString(key, null) == null) {
            return null;
        }
        return this.obj.optBoolean(key);
    }

    public final PObject optObject(String key) {
        return this.optJSONObject(key);
    }

    public final PArray optArray(String key) {
        return this.optJSONArray(key);
    }

    public final boolean isArray(String key) {
        return this.getInternalObj().opt(key) instanceof JSONArray;
    }

    public final PJsonObject optJSONObject(String key) {
        JSONObject val = this.obj.optJSONObject(key);
        return val != null ? new PJsonObject((PElement)this, val, key) : null;
    }

    public final PJsonObject getJSONObject(String key) {
        JSONObject val = this.obj.optJSONObject(key);
        if (val == null) {
            throw new ObjectMissingException((PElement)this, key);
        }
        return new PJsonObject((PElement)this, val, key);
    }

    public final PJsonArray getJSONArray(String key) {
        JSONArray val = this.obj.optJSONArray(key);
        if (val == null) {
            throw new ObjectMissingException((PElement)this, key);
        }
        return new PJsonArray((PElement)this, val, key);
    }

    public final PJsonArray optJSONArray(String key) {
        JSONArray val = this.obj.optJSONArray(key);
        if (val == null) {
            return null;
        }
        return new PJsonArray((PElement)this, val, key);
    }

    public final PJsonArray optJSONArray(String key, PJsonArray defaultValue) {
        PJsonArray result = this.optJSONArray(key);
        return result != null ? result : defaultValue;
    }

    public final Iterator<String> keys() {
        return this.obj.keys();
    }

    public final int size() {
        return this.obj.length();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.obj == null ? 0 : this.obj.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PJsonObject other = (PJsonObject)obj;
        return !(this.obj == null ? other.obj != null : !this.obj.equals(other.obj));
    }

    public final JSONObject getInternalObj() {
        return this.obj;
    }

    public final boolean has(String key) {
        String result = this.obj.optString(key, null);
        return result != null;
    }

    public final String toString() {
        return this.getCurrentPath() + ":\n\t" + this.obj;
    }
}

